# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class TurboPagesCfg(configs.ReferenceBranchedConfig):
    name = "turbo_pages"
    display_name = u"TurboPages"
    responsible = "egorshelk"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "TURBO"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SinglePackagePreset(
                build_task_name="BUILD_RTHUB_PACKAGE",
                build_ctx={"raw_package": False},
                package_names="robot/rthub/packages/rthub_turbo_full_package.json",
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.prestable),
                ],
            )

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                freq_patch = {
                    "_BUILD_RTHUB_TURBO_PAGES": rm_const.TestFrequencies.EACH_REV_TEST
                }
                tests.update(freq_patch)
                return tests

            @property
            def ignore_match(self):
                common_ignored = super(self.__class__, self).ignore_match
                rthub_ignored = [
                    "BUILD_RTHUB_TURBO_PACKAGE",
                    "UPDATE_CONTENT_PLUGINS_CONFIGS",
                    "CHECK_CONTENT_PLUGINS_CONFIGS"
                ]
                return common_ignored + rthub_ignored

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 7

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="rthub_turbo_pages_package",
                    data=ri.SandboxResourceData("RTHUB_TURBO_FULL_PACKAGE", ttl=90),
                    deploy_infos=[ri.single_nanny_service("rthub-turbo-postprocessing-production-yp")],
                ),
                # todo: find out if it's still useful
                # ri.ReleasableItem(
                #     name="rthub_content_plugins_configs",
                #     data=ri.SandboxResourceData("YQL_UDF_CONTENT_PLUGINS_CONFIGS"),
                #     deploy_infos=[ri.single_nanny_service("rthub-turbo-autoparser-production-yp")]
                # )
            ]

        release_followers_permanent = [
            "egorshelk",
            "ilyakuchumov",
            "nshal",
            "shubert",
            "web-chib",
            "zagevalo",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):

        notifications = [
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="turbo_rthub_devops",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="turbo_rthub_devops",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["egorshelk"]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["turbo_rthub_devops"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "egorshelk"
            queue = "TURBORELEASE"
            dev_queue = "TURBO"
            summary_template = u"TurboPages {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "egorshelk",
                "shubert",
                "ilyakuchumov",
                "nshal",
                "web-chib",
                "zagevalo",
            ]
            add_commiters_as_followers = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "jandekspoisk/kachestvopoiska/turbopages/dev/releases/turbo_rthub"
        observed_paths = [
            "arcadia/robot/rthub/main",
            "arcadia/robot/rthub/yql/udfs/turbopages",
            "arcadia/quality/functionality/turbo/parse_lib",
            "arcadia/quality/functionality/turbo/rss/feed_parser_lib",
            "arcadia/quality/functionality/content_plugins/plugins",
        ]
        review_groups = [
            "turbo",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "turbo-pages"
        branch_prefix = "pre-stable"
        tag_name = "turbo-pages"
