# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class TurboRapidClicksCfg(configs.ReferenceCIConfig):
    name = "turbo_rapid_clicks"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="searchpers"),
        login="skorodumov-s",
    )

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        release_manually = False

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "quality/personalization/big_rt/turbo"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-PERS"

        ya_make_abs_paths_glob = [
            "quality/personalization/big_rt/turbo/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="turbo_rapid_clicks_files",
                    build_data=ri.BuildData(
                        target="quality/personalization/big_rt/turbo/parser/pkg.json",
                    ),
                    data=ri.SandboxResourceData("TURBO_RAPID_CLICKS_PARSER_PACKAGE"),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("vbezhentsev-stage"))
                    ],
                ),
                ri.ReleasableItem(
                    name="aggregator_vcdiff_files",
                    build_data=ri.BuildData(
                        target="quality/personalization/big_rt/aggregator_vcdiff/pkg.json",
                    ),
                    data=ri.SandboxResourceData("AGGREGATOR_VCDIFF_PACKAGE_TURBO"),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("vbezhentsev-stage"))
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        use_release_task_as_ti_task_type = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "skorodumov-s"
            queue = "SEARCHPERSREL"
            dev_queue = "SEARCHPERS"
            summary_template = u"Приемка Turbo {}"
            workflow = {}
            followers = [
                "skorodumov-s",
            ]
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "quality/personalization/big_rt/turbo",
        ]
