# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class TutorCfg(configs.ReferenceBranchedConfig):
    name = "tutor"
    responsible = "nkmakarov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "FRESHNESS"
        branch_db_template = "ws-tutor-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _trunk_part(self):
                default_trunk_part = super(self.__class__, self)._trunk_part
                trunk_part = [
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_TRUNK_TUTOR",
                        build_item="trunk",
                        ctx={
                            "build_education": True,
                            "build_type": "release",
                        },
                        out={"EDUCATION_EXECUTABLE": 40},
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="GENERATE_TUTOR_APP_HOST_REQUESTS",
                        job_params={
                            "job_name_parameter": "BENCHMARK_GENERATE_REQUESTS",
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 1440),
                        },
                        out={
                            "APP_HOST_JSON_CONTEXTS": 30,
                        },
                    )
                ]
                return default_trunk_part + trunk_part

            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_SEARCH",
                        ctx={
                            "build_education": True,
                            "build_type": "release",
                        },
                        out={"EDUCATION_EXECUTABLE": 40},
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GET_LAST_TUTOR_APP_HOST_REQUESTS",
                        job_params={
                            "job_name_parameter": "BENCHMARK_GET_REQUESTS",
                        },
                        out={
                            "APP_HOST_JSON_CONTEXTS": 30,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="CREATE_TUTOR_ARCHIVE_RESOURCE",
                        job_params={
                            "job_name_parameter": "BENCHMARK_ARCHIVE_PREVIOUS",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(),
                        ),
                        ctx={
                            "tutor_add_config": 1212702254,
                            "tutor_extractor": 1177535708,
                            "custom_script": 1177627373,
                        },
                        out={
                            "TUTOR_ARCHIVE": 30
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="BENCHMARK_APP_HOST_CUSTOM",
                        job_params={
                            "job_name_parameter": "BENCHMARK_PREVIOUS",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_ARCHIVE_PREVIOUS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="any_app_resource",
                                        resource_name="TUTOR_ARCHIVE",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_GET_REQUESTS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="APP_HOST_JSON_CONTEXTS",
                                        resource_name="APP_HOST_JSON_CONTEXTS",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "timeout": 2000,
                            "DPLANNER_EXECUTABLE": 153063466,
                            "concurrency": 20,
                            "time_multiplier": 3,
                        },
                        out={
                            "APP_HOST_BENCHMARK_TESTS": 30,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="CREATE_TUTOR_ARCHIVE_RESOURCE",
                        job_params={
                            "job_name_parameter": "BENCHMARK_ARCHIVE_CURRENT",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="tutor_binary",
                                        resource_name="EDUCATION_EXECUTABLE",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "tutor_add_config": 1212702254,
                            "tutor_extractor": 1177535708,
                            "custom_script": 1177627373,
                        },
                        out={
                            "TUTOR_ARCHIVE": 30,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="BENCHMARK_APP_HOST_CUSTOM",
                        job_params={
                            "job_name_parameter": "BENCHMARK_CURRENT",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_PREVIOUS",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_GET_REQUESTS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="APP_HOST_JSON_CONTEXTS",
                                        resource_name="APP_HOST_JSON_CONTEXTS",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_ARCHIVE_CURRENT",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="any_app_resource",
                                        resource_name="TUTOR_ARCHIVE",
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "timeout": 2000,
                            "DPLANNER_EXECUTABLE": 153063466,
                            "concurrency": 20,
                            "time_multiplier": 3,
                        },
                        out={
                            "APP_HOST_BENCHMARK_TESTS": 30,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="BENCHMARK_APP_HOST_DIFF2",
                        job_params={
                            "job_name_parameter": "BENCHMARK_DIFF",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_PREVIOUS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="previous_tests",
                                        resource_name="APP_HOST_BENCHMARK_TESTS",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_CURRENT",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="last_tests",
                                        resource_name="APP_HOST_BENCHMARK_TESTS",
                                    )
                                ),
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="TEST_TWO_EDUCATIONS_HANDLERS",
                        job_params={
                            "job_name_parameter": "HANDLERS_DIFF",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_ARCHIVE_PREVIOUS",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="BETA_1_ARCHIVE",
                                        resource_name="TUTOR_ARCHIVE",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_ARCHIVE_CURRENT",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="BETA_2_ARCHIVE",
                                        resource_name="TUTOR_ARCHIVE",
                                    )
                                ),
                            ),
                        ),
                        out={
                            "DIFF_TEST_RESULT": 30
                        },
                        ctx={
                            "TESTS_EXECUTABLE": 1682455756,
                            "TUTOR_CONFIG": 1217002922,
                            "YQL_TOKEN_OWNER": "FRESHNESS",
                            "YQL_TOKEN_NAME": "tutor_yql",
                            "TVM_TOKEN_OWNER": "FRESHNESS",
                            "TVM_TOKEN_NAME": "tutor_tvm_prestable",
                        },
                    ),
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BENCHMARK_DIFF",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="HANDLERS_DIFF",
                            ),
                        ),
                        frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = []
                for release_stage in [rm_const.ReleaseStatus.stable, rm_const.ReleaseStatus.prestable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="tutor",
                                            resource_name="EDUCATION_EXECUTABLE",
                                        )
                                    )
                                )
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )
                return default_release_part + release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_{}_UMBRELLA_ACCEPT_SCHEDULED".format(self.name.upper()): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="tutor",
                    data=ri.SandboxResourceData("EDUCATION_EXECUTABLE"),
                    deploy_infos=[
                        ri.NannyDeployInfo(ri.DeployService("tutor")),
                        ri.NannyDeployInfo(ri.DeployService("tutor_prestable"), stage=rm_const.ReleaseStatus.prestable),
                    ]
                )
            ]

        release_followers_permanent = [
            "nkmakarov",
        ]
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = ["tutor-releases@yandex-team.ru"]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "nkmakarov"  # Ignored when use_task_author_as_assignee = True
            use_task_author_as_assignee = True
            queue = "YOUNGLINGS"
            dev_queue = "YOUNGLINGS"
            summary_template = u"Приемка TUTOR {}"
            workflow = {}
            components = u"! Приемка".encode("utf-8")
            followers = [
                "nkmakarov",
            ]
            add_commiters_as_followers = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "tutor/tutorreleases/"
        dirs = [
            "arcadia/extsearch/younglings/education",
            "arcadia/extsearch/younglings/common",
            "arcadia/yweb/younglings/education",
            "arcadia/yweb/younglings/common"
        ]
