# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data

from sandbox.projects.release_machine.components import configs
from sandbox.projects.common.constants import constants as sandbox_constants


class TutorAdminCfg(configs.ReferenceBranchedConfig):
    name = "tutor_admin"
    responsible = "nkmakarov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "FRESHNESS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_SEARCH",
                        out={"TUTOR_APPHOST_ADMINKA_EXECUTABLE": 180},
                        ctx={
                            "build_tutor_apphost_adminka": True,
                            "build_type": "release",
                            sandbox_constants.USE_AAPI_FUSE: True,
                            sandbox_constants.ALLOW_AAPI_FALLBACK: True
                        }
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release

                for release_stage in [rm_const.ReleaseStatus.prestable, rm_const.ReleaseStatus.stable]:

                    release_part.append(jg_release.JobGraphElementReleaseBranched(
                        release_to=release_stage,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "tutor_apphost_adminka_executable_res_id",
                                        "TUTOR_APPHOST_ADMINKA_EXECUTABLE"
                                    )
                                )
                            )
                        )
                    ))

                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        release_to=release_stage,
                        job_arrows=(
                            jg_job_triggers.JobTriggerRelease(job_name_parameter=release_stage),
                            jg_job_triggers.JobTriggerChangelogFinal()
                        )
                    ))

                return release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = ["tutor-releases@yandex-team.ru"]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "nkmakarov"
            use_task_author_as_assignee = True
            queue = "YOUNGLINGS"
            dev_queue = "YOUNGLINGS"
            summary_template = u"Приемка TUTOR_ADMIN {}"
            workflow = {}
            components = u'! Приемка'.encode('utf-8')
            followers = [
                "nkmakarov",
                "asandler",
                "alexchern",
                "kozlovkr"
            ]
            add_commiters_as_followers = True
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = ""
        dirs = [
            "arcadia/extsearch/younglings/tutor_admin"
        ]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="tutor_admin",
                resource_type="TUTOR_APPHOST_ADMINKA_EXECUTABLE",
                resource_name="tutor_apphost_adminka_executable_res_id",
                deploy=[
                    (rm_const.ReleaseStatus.stable, "tutor_admin_new"),
                    (rm_const.ReleaseStatus.prestable, "tutor_admin_new_hamster")
                ]
            )
        ]
        release_followers_permanent = [
            "nkmakarov",
            "asandler",
            "alexchern",
            "kozlovkr"
        ]
        allow_robots_to_release_stable = True
