# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class UgcFeederCfg(configs.ReferenceBranchedConfig):
    name = "ugc_feeder"
    responsible = "ivannik"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "ugc-feeder-trunk"
        trunk_task_owner = "UGC"
        branch_db_template = "ugc-feeder-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            time_interval_list=[(1, 3)],
                            weekday_list=[1],
                            last_run_finished=False,
                            once_a_day=True
                        )
                    ),
                ]

            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_UGC_FEEDER",
                build_ctx={
                    "ugc_feeder_release": True,
                    sandbox_constants.CLEAR_BUILD_KEY: True
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing, jg_utils.CheckEachCommit()),
                ],
            )

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_TESTING_RELEASE_UGC_FEEDER": rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="ugc_feeder_executable_res_id",
                    data=ri.SandboxResourceData("UGC_FEEDER_EXECUTABLE", ttl=14),
                    deploy_infos=[ri.single_nanny_service("ugc_feeder_vla")],
                ),
            ]

        release_followers_permanent = [
            "ivannik",
            "qqq",
        ]
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "ivannik"
            queue = "UGC"
            dev_queue = "UGC"
            summary_template = u"Приемка UGC Feeder {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "ivannik",
                "qqq",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "JandeksPoisk/UGC/DevOps/releases/ugc_feeder/"
        observed_paths = [
            "arcadia/entity/ugc/data",
            "arcadia/entity/ugc/tools",
            "arcadia/entity/ugc/server",
            "arcadia/entity/ugc/util",
            "arcadia/kernel/ugc",
        ]
        review_groups = [
            "ugc",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "ugc/feeder"
        tag_name = "ugc/feeder"
