from sandbox.projects.release_machine.components.config_core.bases.ci import ReferenceCIConfig


class UpperSearchReferenceCIConfig(ReferenceCIConfig):
    component_group = "reference_component_metricsed"

    def __init__(self):
        self.releases_cfg = self.Releases(self, self.name, self.responsible)
        self.notify_cfg = self.Notify(self.name)
        self.svn_cfg = self.SvnCfg(self.name)
        self.release_viewer_cfg = self.ReleaseViewer()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
        self.yappy_cfg = self.Yappy()
        self.metrics_cfg = self.MetricsCfg()
        self.merges_cfg = self.MergesCfg(self.name)
        self.ci_cfg = self.CI(
            self,
            self.name,
            use_startrek=self.notify_cfg.use_startrek,
            releasable_items=self.releases_cfg.releasable_items,
            release_approvement_required=self.releases_cfg.approvement_required,
        )

        if hasattr(self, "JG"):
            self.jg = self.JG(root_cfg=self, releases_cfg=self.releases_cfg)
            self._uses_newstyle_jg = True
        else:
            self._uses_newstyle_jg = False
