from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base.web.metrics import UpperSearchLaunchMetricsWeb
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import web as sr_web


class SearchIntegrationTestsBundle():
    TestE2E = sr_web.TestE2ETestsWeb
    TestSearchIntegration = sr_web.TestSearchIntegrationTestsCube
    TestSearchIntegrationSoy = sr_web.TestSearchIntegrationSoyHttpTestsCube
    TestXML = sr_web.TestXMLTestsCube
    TestSiteSearchIntegration = sr_web.TestSiteSearchIntegrationTestsCube
    LaunchMetrics = UpperSearchLaunchMetricsWeb

    @classmethod
    def get_bundle(cls, beta_cube, soy_pool):
        """
        Returns list of search integration tests

        :type beta_cube: Cube
        :param beta_cube:
            The name of the beta cube this cube depends on

        :type soy_pool: str
        :param soy_pool:
            The name of the soy_pool

        :return: List[TestE2ETestsCube, TestSearchIntegrationTestsCube, TestSearchIntegrationSoyHttpTestsCube, SearchLaunchMetricsWeb, TestXMLTestsCube, TestSiteSearchIntegrationTestsCube]
        """

        return [
            cls.TestE2E(beta_cube),
            cls.TestSearchIntegration(beta_cube, soy_pool),
            cls.TestSearchIntegrationSoy(beta_cube, soy_pool),
            cls.LaunchMetrics.by_generate_beta_cube(beta_cube, scraper_over_yt_pool=soy_pool),
            cls.TestXML(beta_cube),
            cls.TestSiteSearchIntegration(beta_cube),
        ]
