# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers


class UrlMonitoringCfg(configs.ReferenceBranchedConfig):
    name = "url_monitoring"
    responsible = "nikondr"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "url-monitoring-trunk"
        trunk_task_owner = "YABS_URL_MONITORING_RELEASE"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildPackageBranched(
                        package_names="yabs/stat/url_monitoring2/package.json",
                        resource_names="URL_MONITORING_SERVANTS",
                        use_compression=False,
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 10 * 1024 ** 3,  # 10 Gb
                                },
                            },
                        },
                        out={
                            "URL_MONITORING_SERVANTS": 30,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTrunkWaiter()
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                URL_MONITORING_SAMOGON_NAMESPACES = {
                    rm_const.ReleaseStatus.testing: 7,
                    rm_const.ReleaseStatus.stable: 0,
                }
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="DEPLOY_SAMOGON_SERVANTS",
                            job_params={
                                "job_name_parameter": "DEPLOY_{}".format(release_stage),
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataResource(
                                            input_key="resource",
                                            resource_name="URL_MONITORING_SERVANTS",
                                        ),
                                    )
                                )
                            ),
                            ctx={
                                "auto": False,
                                "project": "url_monitoring",
                                "namespace": URL_MONITORING_SAMOGON_NAMESPACES[release_stage],
                                "samogon_oauth_token_vault_name": "URL_MONITORING_SAMOGON_TOKEN",
                            }
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "url_monitoring_servants_res_id",
                                            "URL_MONITORING_SERVANTS",
                                        )
                                    )
                                ),
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_name_parameter="DEPLOY_{}".format(release_stage),
                                ),
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )
                return release_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 7

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="url_monitoring_servants",
                resource_type="URL_MONITORING_SERVANTS",
                resource_name="url_monitoring_servants_res_id",
            ),
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TestenvDbClone",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewWikiPage",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="AcceptanceTest",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBetaGeneration",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="url_monitoring_comp",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["url_monitoring_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "nikondr"
            queue = "BSRELEASE"
            dev_queue = "BSDEV"
            summary_template = "New YaBS URL monitoring v{}"
            workflow = {}
            followers = [
                "nikondr",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "BannernajaKrutilka/urlmonitoring2/changelog/"
        dirs = [
            "arcadia/yabs/stat/url_monitoring2/lib",
            "arcadia/yabs/stat/url_monitoring2/plugin",
        ]
