# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
import sandbox.projects.release_machine.core.const as rm_const


class UserHistoryCfg(configs.ReferenceCIConfig):
    name = "user_history"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="searchpers"),
        login="skorodumov-s",
    )

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        release_manually = False

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "quality/personalization/big_rt/user_history"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-PERS"

        ya_make_abs_paths_glob = [
            "quality/personalization/big_rt/user_history/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="user_history_package",
                    build_data=ri.BuildData(
                        target="quality/personalization/big_rt/user_history/pkg.json",
                    ),
                    data=ri.SandboxResourceData("USER_HISTORY_PACKAGE"),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("search_big_rt_prestable_A_tmp"), rm_const.ReleaseStatus.prestable),
                        ri.YaDeployInfo(ri.DeployService("searchpers_big_rt"), rm_const.ReleaseStatus.stable),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        use_release_task_as_ti_task_type = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "skorodumov-s"
            queue = "SEARCHPERSREL"
            dev_queue = "SEARCHPERS"
            summary_template = u"Приемка UserHistory {}"
            workflow = {}
            followers = [
                "skorodumov-s",
            ]
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "quality/personalization/big_rt/user_history",
        ]
