# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.common.constants import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows

ZERO_RESTART_POLICY = (
    {
        "sleep_before_action": 0,  # min
        "default_action": rm_const.RestartPolicyActions.NOOP,
    },
)


class UserSessionsCfg(configs.ReferenceBranchedConfig):
    name = "user_sessions"
    responsible = configs.Responsible(login="bagiro44", abc=configs.Abc(component_id=33128, schedule_slug='rtyt', role_id=None))

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "user_sessions_trunk"
        trunk_task_owner = "USERSESSIONSTOOLS"
        branch_db_template = "user_sessions_processes_test-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            MAIL_LIST = 'usersessions-releases@yandex-team.ru'

            PREPARE_RTMR_FOR_YF_CTX = {
                "account_names": "user_sessions",
                "build_disk_space": "60",
                "build_sys": False,
                "build_userdata": False,
                "build_usertasks": True,
                "cleanup_first": True,
                "cleanup_missing": False,
                "clusters": ["rtmr-man-prestable", "rtmr-vla", "rtmr-sas"],
                "create_debug_packages": False,
                "deploy_to_yf": False,
                "parallel_limit": "99",
                "publish_packages": False,
                "statface_password_vault": "USER_SESSIONS_STATFACE_TOKEN",
                "statface_password_vault_owner": "USERSESSIONSTOOLS",
                "statface_username": "robot-make-sessions",
                "strip_packages": False,
                "switch": True,
                "task_ids": "create_sessions,create_scarab_sessions,create_proto_sessions,parselib_errors,baobab_enrich",
                "update_previous": False,
                "ya_package_name_for_sign": "zomb-prj-216",
            }

            RTMR_GRAPH_RELEASE_CTX = {
                "add_last_userdata_resource": False,
                "build_disk_space": "60",
                "build_graphs": True,
                "build_userdata": False,
                "cleanup_missing": False,
                "clusters": ["rtmr-man-prestable", "rtmr-vla", "rtmr-sas"],
                "create_debug_packages": False,
                "graphs": "user_sessions",
                "oauth_token_name": "rtmr_deploy_usertask_yf_oauth_token",
                "parallel_limit": "10",
                "strip_packages": False,
                "statface_password_vault": "USER_SESSIONS_STATFACE_TOKEN",
                "statface_password_vault_owner": "USERSESSIONSTOOLS",
                "statface_username": "robot-make-sessions",
                "ya_package_name_for_sign": "zomb-prj-216",
            }

            DEPLOY_RTMR_FOR_YF_DEPLOY_CTX_PRESTABLE = {"cluster": "rtmr-man-prestable"}

            DEPLOY_RTMR_GRAPH_FOR_YF_CTX = {
                "graph": "user_sessions",
                "cluster": "rtmr-man-prestable",
                "oauth_token_name": "ROBOT_MAKE_SESSIONS",
            }

            DEPLOY_RTMR_FOR_YF_DEPLOY_CTX = {
                "account": "user_sessions",
                "cleanup_first": True,
                "cleanup_missing": False,
                "cluster": "rtmr-man-prestable",
                "oauth_token_name": "ROBOT_MAKE_SESSIONS",
                "switch": True,
                "update_previous": True,
            }

            @property
            def _prerelease(self):
                return [
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="GET_LAST_GOOD_REVISION",
                        job_params={
                            "job_name_parameter": "GET_LAST_GOOD_REVISION",
                        },
                        ctx={"jobs_list": "USER_SESSIONS_ENVIRONMENT_TEST"},
                    ),
                    jg_prerelease.JobGraphElementNewBranch(
                        job_params={
                            "ctx": {
                                "custom_comment": "[rm:beta]",
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="GET_LAST_GOOD_REVISION",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="revision_for_trunk",
                                        output_key="good_revision",
                                        transform=lambda x, params: str(x),
                                        override=True,
                                    )
                                )
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestTrunkCommon(
                        task_name="USER_SESSIONS_HELPER",
                        job_params={
                            "job_name_parameter": "BRANCH_MAIL",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewBranch(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="release_num",
                                        output_key="new_branch_number",
                                        transform=lambda x, params: str(x),
                                    ),
                                )
                            ),
                            jg_arrows.ParentsData(
                                input_key="message",
                                triggers=(
                                    jg_job_triggers.JobTriggerTestBranchCommon(
                                        job_name_parameter="GET_LAST_GOOD_REVISION",
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="start_revision",
                                                output_key="good_revision",
                                            ),
                                        ),
                                    ),
                                    jg_job_triggers.JobTriggerStartrek(),
                                    jg_job_triggers.JobTriggerNewBranch(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_revision",
                                                output_key="result_revision",
                                            ),
                                        ),
                                    ),
                                ),
                                transform=lambda start_revision, startrek_issue, result_revision: (
                                    "Current stable branch has been created today. "
                                    "Start branch revision {}. Trunk revision {}. {}"
                                ).format(result_revision, start_revision, startrek_issue),
                            )

                        ),
                        ctx={
                            "maillistSummonees": self.MAIL_LIST,
                            "send_to_tg": True,
                            "send_to_st": True,
                            "send_to_email": True,
                            "add_duty_login": True,
                            "subject": "New branch",
                        }
                    ),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="BRANCH_MAIL",
                            ),
                        ),
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            time_interval_list=[(4, 4)],
                            seconds_from_last_run_commit=1.5 * 3600,
                            weekday_list=[0, 2],
                        ),
                    ),
                ]

            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GET_LAST_GOOD_RELEASE_INFO",
                        job_params={
                            "job_name_parameter": "CREATE_PREV_RELEASE",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="new_branch",
                                transform=lambda x, rm_config: x.svn_ssh_url,
                            )
                        ),
                    ),
                ]
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RTMR_GRAPH_RELEASE",
                        job_params={
                            "job_name_parameter": "RTMR_PREPARE_FOR_YF",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_PREV_RELEASE",
                                parent_job_data=None
                            ),
                            jg_arrows.ParamsData(
                                input_key="arcadia_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        ),
                        ctx=self.RTMR_GRAPH_RELEASE_CTX
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="USER_SESSIONS_HELPER",
                        job_params={
                            "job_name_parameter": "RTMR_CREATE_RESOURCE",
                        },

                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RTMR_PREPARE_FOR_YF",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="rtmr_yf_task",
                                    )
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                        ctx={
                            "rtmr_prepare_resource": True,
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RTMR_DEPLOY_USERTASK_YF",
                        job_params={
                            "job_name_parameter": "DEPLOY_TO_YF",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RTMR_PREPARE_FOR_YF",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="build_task",
                                    )
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                        ctx=self.DEPLOY_RTMR_FOR_YF_DEPLOY_CTX_PRESTABLE
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="PRIEMKA_CREATE_SESSIONS",
                        job_params={
                            "job_name_parameter": "CREATE_DIFF",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_PREV_RELEASE",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="release_param",
                                        output_key="new_branch_name",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="svn_path1",
                                        output_key="svn_old_branch_path",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="svn_path2",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                        ctx={
                            "yt_token": "SCARAB_ZOMB_YT_KEY",
                            "yt_token_owner": "zomb-sean",
                            "yt_pool": "zomb-sean",
                            "destination_folder_selector": "auto",
                            "mr_cluster": "hahn",
                            "data_folder": "//home/userdata-sessions-build-ci",
                            "is_running_on_yt": True,
                            "revision1_build_type": "from_auto_packages",
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="DEPLOY_RULE_MONITORING",
                        job_params={
                            "job_name_parameter": "RUN_RULE_MONITORING",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_PREV_RELEASE",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="old_revision",
                                        output_key="svn_old_branch_path",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="new_revision",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=jg_utils.get_major_release_number,
                            ),
                        ),
                        ctx={
                            "is_get_old_branch_auto": False,
                            "is_release_machine_mode": True,
                            "commit_author": "bagiro44",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="GET_DIFF_RESOURCE_FOR_US",
                        job_params={
                            "job_name_parameter": "SEND_DIFF_TO_ST",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_DIFF",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="diff_task_id",
                                    )
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                    )
                )
                PACKAGES = [
                    "packages/debian/mapreduce/yandex-search-converters-imgreqans2scarab/yandex-search-converters-imgreqans2scarab.json",
                    "packages/debian/mapreduce/yandex-search-converters-joined-bs-dsp-rtb2scarab/yandex-search-converters-joined-bs-dsp-rtb2scarab.json",
                    "packages/debian/mapreduce/yandex-search-converters-reqans2scarab/yandex-search-converters-reqans2scarab.json",
                    "packages/debian/mapreduce/yandex-search-create-scarab-sessions/yandex-search-create-scarab-sessions.json",
                    "packages/debian/mapreduce/yandex-search-filters-rtb-ad-logs/yandex-search-filters-rtb-ad-logs.json",
                    "packages/debian/mapreduce/yandex-search-logs-logs2mapreduce/yandex-search-logs-logs2mapreduce.json",
                    "packages/debian/mapreduce/yandex-search-market2scarab/yandex-search-market2scarab.json",
                    "packages/debian/mapreduce/yandex-search-mr-logs-user-sessions-errors-stable/yandex-search-mr-logs-user-sessions-errors-stable.json",
                    "packages/debian/mapreduce/yandex-search-sessions-create-nano-sessions/yandex-search-sessions-create-nano-sessions.json",
                    "packages/debian/mapreduce/yandex-search-sessions-sessions/yandex-search-sessions-sessions.json",
                    "packages/debian/mapreduce/yandex-search-splitter-imgreqans/yandex-search-splitter-imgreqans.json",
                    "packages/debian/mapreduce/yandex-search-splitter-reqans/yandex-search-splitter-reqans.json",
                    "packages/debian/mapreduce/yandex-search-spy-log-session-activity-extraction/yandex-search-spy-log-session-activity-exctraction.json",
                    "packages/debian/mapreduce/yandex-search-spy-log-session-activity-join/yandex-search-spy-log-session-activity-join.json",
                    "packages/debian/mapreduce/yandex-search-user-sessions-error-stats/yandex-search-user-sessions-error-stats.json",
                    "packages/debian/mapreduce/yandex-search-usersessions-gen-ads-descriptions/yandex-search-usersessions-gen-ads-descriptions.json",
                    "packages/debian/mapreduce/yandex-search-watch-log-session-unique/yandex-search-watch-log-session-unique.json",
                    "packages/debian/mapreduce/yandex-search-weatheraccess2scarab/yandex-search-weatheraccess2scarab.json",
                    "packages/debian/mapreduce/yandex-search-scarab-logsng2scarab/yandex-search-scarab-logsng2scarab.json",
                ]
                branch_part.append(
                    jg_build.JobGraphElementBuildPackageBranched(
                        resource_names="YA_PACKAGE",
                        job_params={
                            "job_name_parameter": "CREATE_Z2_BIN",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        package_names=";".join(PACKAGES),
                        ctx={
                            "host_platform": "linux",
                            "package_type": "debian",
                            "publish_to": "search-precise",
                            "publish_package": True,
                            "strip_binaries": True,
                            "use_new_format": True,
                            "ya_timeout": 19000,
                            "key_user": "zomb-prj-216",
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.SEMI_DISTBUILD_BUILD_SYSTEM,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RELEASE_USER_SESSIONS_BINARIES",
                        job_params={
                            "job_name_parameter": "CREATE_REACTOR_BIN",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="reg_general_arcadia_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                        ctx={
                            "reg_customize_binaries": False,
                            "nonreg_customize_binaries": False,
                            "reg_nirvana_ttl_days": 30,
                            "reg_binaries_build_method": "general_arcadia_url",
                            "nonreg_binaries_build_method": "do_not_build",
                            "reactor_token_secret_owner": "USERSESSIONSTOOLS",
                            "reactor_token_secret_name": "prod_reactor_token",
                            "nirvana_token_secret_owner": "USERSESSIONSTOOLS",
                            "nirvana_token_secret_name": "prod_nirvana_token",
                            "nirvana_quota_name": "user-sessions",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SEND_DIFF_TO_ST",
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="CREATE_Z2_BIN",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_REACTOR_BIN",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RTMR_CREATE_RESOURCE",
                            ),
                            jg_job_triggers.JobTriggerActionRelease(
                                job_name_parameter="0_PREPARE_BIN_RESOURCE__{}".format(rm_const.ReleaseStatus.stable),
                            ),
                            jg_job_triggers.JobTriggerActionRelease(
                                job_name_parameter="RELEASE_RTMR_PRESTABLE__{}".format(rm_const.ReleaseStatus.stable),
                            )
                        )
                    )
                )
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="RTMR_DEPLOY_GRAPH_YF",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="RELEASE_RTMR_PRESTABLE",
                        job_params={
                            "ctx": self.DEPLOY_RTMR_GRAPH_FOR_YF_CTX,
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RTMR_PREPARE_FOR_YF",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="build_task",
                                    ),
                                ),
                            ),
                        ),
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="RELEASE_RTMR_PRESTABLE",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="PREPARE_USRMRESOURCE",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="0_PREPARE_BIN_RESOURCE",
                        job_params={
                            "ctx": {
                                "mode": "Binaries",
                            },
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_REACTOR_BIN",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="reactor_task_id",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="CREATE_Z2_BIN",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="z2_task_id",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SEND_DIFF_TO_ST",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RUN_RULE_MONITORING",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RTMR_CREATE_RESOURCE",
                            ),
                        ),
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="0_PREPARE_BIN_RESOURCE",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RELEASE_USER_SESSIONS_BIN_ON_TIME",
                        job_params={
                            "job_name_parameter": "RELEASE_BIN_ON_TIME",
                            "ctx": {
                                "mode": "Binaries",
                            },
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="USER_SESSIONS_HELPER",
                        job_params={
                            "job_name_parameter": "RELEASE_RTMR_ON_TIME",
                            "ctx": {
                                "rtmr_release_mode": "True",
                                "add_duty_login": True
                            },
                            "restart_policy": ZERO_RESTART_POLICY,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RELEASE_BIN_ON_TIME",
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="USER_SESSIONS_HELPER",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="1_RELEASE_BIN",
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RELEASE_RTMR_ON_TIME",
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="1_RELEASE_BIN",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="USER_SESSIONS_PROCESSES_TEST",
                        job_params={
                            "job_name_parameter": "SCRIPTS",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="arcadia_url_with_revision",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                        ),
                        ctx={
                            "check_progress_tries": 60,
                            "custom_yt_pool": "userdata-sessions-build-ci",
                            "yt-token": "custom",
                            "custom-yt-token": "SCARAB_ZOMB_YT_KEY",
                            "yt_token_owner": "zomb-sean",
                            "use_default_packet_labels_for_fast": True,
                            "use_default_packet_labels_for_daily": True,
                            "substitute_yt_pools_with_custom_one": True,
                            "set_output_removal_attrs": True,
                            "next_check_progress_after": 180,
                            "mr_cluster": "hahn",
                            "monitor_error_stats": True,
                            "manual_recalc_mode": False,
                            "launch_fast": True,
                            "launch_daily": True,
                            "keep_build_tables": True,
                            "how_to_fetch_binaries": "rsync",
                            "fetch_path": "home/userdata-sessions-build-ci/user-sessions-processes-ci/2016-12-12",
                            "fast_queue_working_limit": 5,
                            "fast_datetime": "2016-12-12:21:00",
                            "days_to_store_output": 3,
                            "daily_queue_working_limit": 5,
                            "daily_datetime": "2016-12-11:00:00",
                            "customize_binaries": False,
                        }
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="USER_SESSIONS_HELPER",
                        job_params={
                            "job_name_parameter": "SCRIPTS_TEST_ALERT",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParentsData(
                                input_key="message",
                                triggers=(
                                    jg_job_triggers.JobTriggerTestBranchCommon(
                                        job_name_parameter="SCRIPTS",
                                        parent_job_data=(
                                            jg_job_data.ParentDataId(
                                                input_key="task_id",
                                            ),
                                        )
                                    ),
                                ),
                                transform=lambda task_id: "(((https://sandbox.yandex-team.ru/task/{}/view Scripts tests result)).".format(
                                    task_id,
                                ),
                            ),
                        ),
                        ctx={
                            "send_to_tg": True,
                            "send_to_st": True,
                            "add_duty_login": True,
                        },
                    ),
                    jg_build.JobGraphElementBuildPackageBranched(
                        resource_names="YA_PACKAGE",
                        job_params={
                            "job_name_parameter": "CREATE_Z2_SCRIPT",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SCRIPTS",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SCRIPTS_TEST_ALERT",
                            ),
                        ),
                        package_names=";".join([
                            "packages/debian/mapreduce/yandex-rem-sessions-scripts/yandex-rem-sessions-scripts.json",
                            "packages/debian/mapreduce/yandex-search-scarab-logsng2scarab/yandex-search-scarab-logsng2scarab.json",
                            "packages/debian/mapreduce/yandex-python-scarab/yandex-python-scarab.json"
                        ]),
                        ctx={
                            "host_platform": "linux",
                            "package_type": "debian",
                            "publish_to": "search-precise",
                            "publish_package": True,
                            "strip_binaries": True,
                            "use_new_format": True,
                            "ya_timeout": 19000,
                            "key_user": "zomb-prj-216",
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.SEMI_DISTBUILD_BUILD_SYSTEM,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RELEASE_USER_SESSIONS_SCRIPTS",
                        job_params={
                            "job_name_parameter": "CREATE_REACTOR_GRAPH",
                            "apiargs": {
                                "kill_timeout": 8 * 3600,
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SCRIPTS",
                            ),
                            jg_arrows.ParamsData(
                                input_key="reg_general_arcadia_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        ),
                        ctx={
                            "reactor_token_secret_owner": "USERSESSIONSTOOLS",
                            "reactor_token_secret_name": "prod_reactor_token",
                            "is_debug": False,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RELEASE_USER_SESSIONS_SCRIPTS",
                        job_params={
                            "job_name_parameter": "CREATE_FALLBACK_REACTOR_GRAPH",
                            "apiargs": {
                                "kill_timeout": 8 * 3600,
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SCRIPTS",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_REACTOR_GRAPH",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="reactor_task_id",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="reg_general_arcadia_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        ),
                        ctx={
                            "reactor_token_secret_owner": "USERSESSIONSTOOLS",
                            "reactor_token_secret_name": "prod_reactor_token",
                            "is_debug": False,
                            "fallback_mode": True,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="PREPARE_USRMRESOURCE",
                        job_params={
                            "job_name_parameter": "FALLBACK_PREPARE_SCRIPTS_RESOURCE",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_FALLBACK_REACTOR_GRAPH",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="reactor_task_id",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                        ),
                        ctx={
                            "mode": "Scripts",
                            "fallback_mode": True,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="PREPARE_USRMRESOURCE",
                        job_params={
                            "job_name_parameter": "PROD_PREPARE_SCRIPTS_RESOURCE",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="CREATE_Z2_SCRIPT",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="z2_task_id",
                                    ),
                                ),
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="CREATE_REACTOR_GRAPH",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="reactor_task_id",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                        ),
                        ctx={
                            "mode": "Scripts",
                        },
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="USER_SESSIONS_HELPER",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="2_PREPARE_SCRIPTS_RESOURCE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="PROD_PREPARE_SCRIPTS_RESOURCE",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="FALLBACK_PREPARE_SCRIPTS_RESOURCE",
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="2_PREPARE_SCRIPTS_RESOURCE",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="USER_SESSIONS_HELPER",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="SUCCESS_RELEASE_MAIL",
                        job_params={
                            "ctx": {
                                "announce": True,
                                "maillistSummonees": self.MAIL_LIST,
                                "send_to_tg": True,
                                "send_to_email": True,
                                "add_duty_login": True,
                                "set_bin_released": True,
                            },
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="SUCCESS_RELEASE_MAIL",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RELEASE_USER_SESSIONS_BIN_ON_TIME",
                        job_params={
                            "job_name_parameter": "RELEASE_SCRIPTS_ON_TIME",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        ),
                        ctx={
                            "mode": "Scripts",
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="RELEASE_USER_SESSIONS_BIN_ON_TIME",
                        job_params={
                            "job_name_parameter": "RELEASE_FALLBACK_SCRIPTS_ON_TIME",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        ),
                        ctx={
                            "mode": "Scripts",
                            "fallback_mode": True,
                        },
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="DEPLOY_SCARAB_PYTHON_API",
                        job_params={
                            "job_name_parameter": "RELEASE_PYTHON",
                        },
                        ctx={
                            "publish_packages": True,
                            "publish_arcadia": False,
                        },
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="USER_SESSIONS_HELPER",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="3_RELEASE_SCRIPTS",
                        job_params={
                            "ctx": {
                                "close_st": True,
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RELEASE_PYTHON",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RELEASE_SCRIPTS_ON_TIME",
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        )
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="USER_SESSIONS_HELPER",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="FB_3_RELEASE_SCRIPTS",
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="RELEASE_FALLBACK_SCRIPTS_ON_TIME",
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_num",
                                transform=jg_utils.get_major_release_number,
                            ),
                            jg_arrows.ParamsData(
                                input_key="branch_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        )
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        task_name="RELEASE_USER_SESSIONS_SCRIPTS",
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="FB_REVERT_TO_PROD",
                        job_params={
                            "ctx": {
                                "reactor_token_secret_owner": "USERSESSIONSTOOLS",
                                "reactor_token_secret_name": "prod_reactor_token",
                                "is_debug": False,
                                "fallback_mode": True,
                                "revert_from_fallback": True,
                            },
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key="reg_general_arcadia_url",
                                transform=jg_utils.arcadia_svn_url_with_revision,
                                override=True,
                            ),
                        ),
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="FB_3_RELEASE_SCRIPTS",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="FB_REVERT_TO_PROD",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_item="3_RELEASE_SCRIPTS",
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                ]
                return default_release_part + release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                uppercase_name = self.name.upper()
                return {
                    "_{}_DAILY_PRIEMKA".format(uppercase_name): rm_const.TestFrequencies.ONCE_A_DAY_TEST,
                    "_LOG_MERGE__{}".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_{}_UMBRELLA_ACCEPT_BY_MARKER".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_{}_UMBRELLA_ACCEPT_SCHEDULED".format(uppercase_name): rm_const.TestFrequencies.ONCE_A_DAY_TEST,
                    "_BUILD_RELEASE_{}".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_{}SEARCH".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_NEW_TAG__{}".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "SUCESS_RELEASE_MAIL_{}".format(uppercase_name): rm_const.TestFrequencies.LAZY_TEST,
                }

            @property
            def ignore_match(self):
                common_ignored = super(self.__class__, self).ignore_match
                return common_ignored + [
                    "_TEST__{}__GET_LAST_GOOD_REVISION".format(self.name.upper()),
                    "_TEST__{}__BRANCH_MAIL".format(self.name.upper()),
                ]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="US_BINARIES_RELEASE_INFO",
                resource_type="US_BINARIES_RELEASE_INFO",
                build_ctx_key="reg_general_arcadia_url",
            ),
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TestenvDbClone",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewWikiPage",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="user_sessions_comp::telegram",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["user_sessions_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = configs.Responsible(login="bagiro44", abc=configs.Abc(component_id=33128, schedule_slug='rtyt', role_id=None))
            queue = "USREL"
            dev_queue = "ZBL"
            summary_template = u"[r{}] User sessions release"
            workflow = {}
            followers = [
                u"gavrgavr",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "logs/release/releaseshistory/"
        dirs = [
            "arcadia/scarab/",
            "arcadia/quality/logs/baobab/",
            "arcadia/quality/logs/omnibus/",
            "arcadia/quality/logs/parse_lib/",
            "arcadia/quality/logs/scarab/",
            "arcadia/quality/logs/tools/",
            "arcadia/quality/logs/util/",
            "arcadia/quality/user_sessions/",
        ]
