# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.common.constants import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class UserfeatViewersCfg(configs.ReferenceTrunkConfig):
    component_group = 'component_info_general'
    name = "userfeat_viewers"
    responsible = "niknik"

    class Testenv(configs.ReferenceTrunkConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "userdata_full_trunk_yt"
        trunk_task_owner = "USERFEAT"

        class JobGraph(configs.ReferenceTrunkConfig.Testenv.JobGraph):
            @property
            def _trunk_part(self):
                return [
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="YA_MAKE_RELEASE_TO_NANNY",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 20 << 30,  # 20 Gb
                                },
                            },
                        },
                        ctx={
                            "targets": "quality/userdata/packages/viewers",
                            "arts": "quality/userdata/packages/viewers",
                            "arts_source": "",
                            "result_rt": "USERFEAT_VIEWERS",
                            "result_rd": "Userfeat viewers",
                            "result_single_file": True,
                            sandbox_constants.CHECKOUT_MODE: sandbox_constants.CHECKOUT_MODE_AUTO,
                            sandbox_constants.CHECKOUT: True,
                            sandbox_constants.BUILD_SYSTEM_KEY: sandbox_constants.YMAKE_BUILD_SYSTEM,
                            sandbox_constants.CLEAR_BUILD_KEY: False,
                            sandbox_constants.CHECK_RETURN_CODE: True,
                            sandbox_constants.TESTS_REQUESTED: False,
                        },
                        out={"USERFEAT_VIEWERS": 30},  # days to store
                    )
                ]

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBase(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "userfeat_viewers_resource_id",
                                        "USERFEAT_VIEWERS",
                                    ),
                                ),
                            ),
                        ),
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                        }
                    ),
                    jg_release.JobGraphElementActionSingleRelease(
                        job_name_parameter=rm_const.ReleaseStatus.stable,
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                        }
                    ),
                ]
                return default_release_part + release_part

    class Releases(configs.ReferenceTrunkConfig.Releases):
        resources_info = [
            configs.ReleasedResourceInfo(
                name="userfeat_viewers_resource_id",
                resource_type="USERFEAT_VIEWERS",
            ),
        ]
