# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg import flow
from sandbox.projects.release_machine.components.config_core.jg import cube as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import run_command
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class VcsIndexerCfg(configs.ReferenceCIConfig):
    name = "vcs_indexer"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="releasemachine"),
        login="mvel",
    )

    class JG(basic_build_presets.SingleBuildYaMakeTemplateJGCfg):
        build_task = "projects/vcs_indexer/build_vcs_indexer"

        @flow.register_flow(
            triggers=[flow.ActionTrigger(
                on=flow.ActionTriggerOn.COMMIT,
                filters=[
                    {
                        "discovery": "dir",
                        "sub-paths": ["*/**"],
                    },
                ],
            )],
        )
        def update_data(self):
            update_cube = run_command.RunCommand(
                name="update_cube",
                input=jg_cube.CubeInput(
                    config={
                        "logs_config": {
                            "stdout_ci_badge": True,
                            "redirect_stderr_to_stdout": True,
                        },
                        "cmd_line": "set -xe\nls -la * > ls_result",
                        "result_output": [
                            {
                                "path": "ls_result",
                            },
                        ],
                        "secret_environment_variables": [
                            {
                                "key": "YT_TOKEN",
                                "secret_spec": {
                                    "uuid": "ver-01emzq3xn65tze7cqx0k41gds6",
                                    "key": "YT_TOKEN",
                                },
                            },
                        ],
                    },
                ),
            )
            return graph_base.Graph([update_cube])

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "release_machine/vcs_indexer"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            "release_machine/vcs_indexer/**",
        ]

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                configs.ri.ReleasableItem(
                    name="vcs_indexer_indexer_binary",
                    data=configs.ri.SandboxResourceData("VCS_INDEXER_INDEXER_BINARY"),
                    deploy_infos=[
                        configs.ri.YaDeployInfo(configs.ri.DeployService("vcs-indexer")),
                        configs.ri.YaDeployInfo(
                            configs.ri.DeployService("vcs-indexer"),
                            stage=configs.rm_const.ReleaseStatus.testing,
                        ),
                    ],
                ),
                configs.ri.ReleasableItem(
                    name="vcs_indexer_updater_binary",
                    data=configs.ri.SandboxResourceData("VCS_INDEXER_UPDATER_BINARY"),
                    deploy_infos=[
                        configs.ri.YaDeployInfo(configs.ri.DeployService("vcs-indexer")),
                        configs.ri.YaDeployInfo(
                            configs.ri.DeployService("vcs-indexer"),
                            stage=configs.rm_const.ReleaseStatus.testing,
                        ),
                    ],
                ),
                configs.ri.ReleasableItem(
                    name="vcs_indexer_arc_updater_binary",
                    data=configs.ri.SandboxResourceData("VCS_INDEXER_ARC_UPDATER_BINARY"),
                    deploy_infos=[
                        configs.ri.YaDeployInfo(configs.ri.DeployService("vcs-indexer")),
                        configs.ri.YaDeployInfo(
                            configs.ri.DeployService("vcs-indexer"),
                            stage=configs.rm_const.ReleaseStatus.testing,
                        ),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = [
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "arcadia/release_machine/vcs_indexer",
        ]
