# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.common.constants import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class VideoBaseCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "video_base"
    responsible = "juver"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "video-base-trunk"
        trunk_task_owner = "VIDEODEV"
        branch_db_template = "video-base-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_VIDEOSEARCH_BUNDLE",
                        ctx={
                            "components": "build_all",
                            sandbox_constants.THINLTO: True,
                        },
                        out={
                            "VIDEOSEARCH_EXECUTABLE": 90,
                            "VIDEO_SEARCH_CONFIG": 90,
                        },
                    ),
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="video_base_executable_res_id",
                                        resource_name="VIDEOSEARCH_EXECUTABLE",
                                    )
                                )
                            )
                        ),
                        ctx={"beta_name_source": "STRING", "patch_name": "priemka"},
                    ),
                    jg_test.JobGraphElementLaunchMetrics(
                        search_subtype="video",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "enable_autoclicker": False,
                            "sample_beta": "priemka-vid.hamster",
                            "scraper_over_yt_pool": "base_video_priemka",
                        }
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="VIDEO_PRIEMKA_BASESEARCH_BINARY",
                        job_params={
                            "job_name_parameter": "DAILY_PRIEMKA",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataId("build_task_id"),
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="revision_tested",
                                transform=lambda x, rm_config: x.revision,
                            ),
                            jg_arrows.ParamsData(
                                input_key="release_number",
                                transform=jg_utils.get_major_release_number,
                            ),
                        )
                    )
                ]
                umbrella_arrows = (
                    jg_job_triggers.JobTriggerLaunchMetrics(
                        job_name_parameter="video",
                    ),
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=umbrella_arrows,
                        frequency=(jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 42),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=umbrella_arrows,
                    )
                )
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "video_base_executable_res_id",
                                        "VIDEOSEARCH_EXECUTABLE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "video_base_config_res_id",
                                        "VIDEO_SEARCH_CONFIG",
                                    )
                                )
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                ]
                return default_release_part + release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_VIDEO_BASE_UMBRELLA_ACCEPT_SCHEDULED": rm_const.TestFrequencies.FORTY_TWO_TEST
                })
                return tests

            @property
            def ignore_match(self):
                common_ignored = super(self.__class__, self).ignore_match
                return common_ignored + [
                    "BUILD_VIDEO_BASESEARCH_FUZZER",
                    "VIDEO_BASE_FUZZY",
                    "VIDEO_BASE_FUZZY_WITH_COVERAGE",
                    "PREPARE_VIDEO_BASE_FUZZY_INPUT",
                ]  # SEARCH-4376

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="video_base",
                resource_type="VIDEOSEARCH_EXECUTABLE",
                resource_name="video_base_executable_res_id",
                deploy=[(rm_const.ReleaseStatus.stable, "vla-video-base-resources")],
            ),
            configs.ReleasedResourceInfo(
                name="video_base_config_res_id",
                resource_type="VIDEO_SEARCH_CONFIG",
            ),
        ]
        release_followers_permanent = [
            "juver",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "juver"
            queue = "BETATEST"
            dev_queue = "VIDEO"
            summary_template = u"Приемка видео базового поиска {}"
            components = u"Видео базовый поиск".encode("utf-8")
            workflow = {}
            followers = [
                "mincer",
                "juver",
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 7
            nanny_reports = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "video/VideoPoisk/quality/basesearch/releases/"
        dirs = [
            "arcadia/extsearch/video/base",
            "arcadia/extsearch/video/kernel",
        ]

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        """Metrics configuration"""
        limit_s = None

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "video/base"
        tag_name = "video/base"

    class Yappy(yappy_cfg.YappyBaseCfg):

        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="base-video",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="base-video",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="basesearch.executable",
                                param_name="video_base_executable_res_id",
                                checkconfig_name="base-linux-bin-md5",
                            ),
                            yappy_cfg.YappyStaticResource(local_path="basesearch.models", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.executable", manage_type="BC_DEFAULT"),
                            yappy_cfg.YappyStaticResource(local_path="mmeta.models", manage_type="BC_DEFAULT"),
                        ],
                    ),
                ],
            ),
        }
