# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class VideoHostingGraphsCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "video_hosting_graphs"
    responsible = "i-sokolov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "VH"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            last_run_finished=False,
                            seconds_from_last_run_commit=3600,
                            time_interval_list=[(4, 6)],
                            weekday_list=[2],
                            once_a_day=True,
                        ),
                    ),
                ]

            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_HORIZON_AGENT_CONFIG",
                        build_item="HORIZON_AGENT_CONFIG",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="stable_branch",
                                        output_key="result_path",
                                        transform=lambda x, params: x.replace("arcadia:/arc/", "").replace("/", "_"),
                                    )
                                )
                            )
                        ),
                        ctx={
                            "vertical": "VIDEO_HOSTING",
                        },
                        out={
                            "HORIZON_AGENT_CONFIG_VIDEO_HOSTING": 90,
                            "APP_HOST_STABLE_BRANCH_VIDEO_HOSTING": 90,
                        },
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                    ),
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="apphost",
                        ctx={
                            "wait_time": 400,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="HORIZON_AGENT_CONFIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "horizon_agent_config_res_id",
                                        "HORIZON_AGENT_CONFIG_VIDEO_HOSTING",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "stable_branch_res_id",
                                        "APP_HOST_STABLE_BRANCH_VIDEO_HOSTING",
                                    ),
                                )
                            )
                        )
                    ),
                ]
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="VH_FRONTEND_JSON_SCHEMA_VALIDATOR",
                        job_params={
                            "job_name_parameter": "VH_VALIDATION_TEST",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="apphost",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="host",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster.yandex.ru".format(x),
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "binary_executor_release_type": "stable"
                        },
                    ),
                )
                umbrella_arrows = [
                    jg_job_triggers.JobTriggerTestBranchCommon(
                        job_name_parameter="VH_VALIDATION_TEST",
                    )
                ]
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=umbrella_arrows,
                        job_params={
                            "frequency": (jg_utils.TestFrequency.EVERY_N_COMMIT, 1000000),
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=umbrella_arrows,
                    )
                )
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = []
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_stage_job_params = None if release_stage == rm_const.ReleaseStatus.stable else {
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    }
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="HORIZON_AGENT_CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="stable_branch_res_id",
                                            resource_name="APP_HOST_STABLE_BRANCH_VIDEO_HOSTING",
                                        ),
                                    ),
                                )
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_params=release_stage_job_params
                        )
                    )
                return default_release_part + release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="video_hosting_mappings",
                resource_type="APP_HOST_STABLE_BRANCH_VIDEO_HOSTING",
                resource_name="stable_branch_res_id",
                deploy=[configs.DeployServicesInfo(services=["production_app_host_vla_vh"])],
            ),
        ]
        release_followers_permanent = [
            "fawnd2",
            "i-sokolov"
        ]
        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="video_hosting_graphs",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="video_hosting_graphs",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="video_hosting_graphs",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications"""
            chats = [rm_const.RMNames.VIDEO_HOSTING_GRAPHS]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/joinchat/BJUUBRU62f6cFdqVRbVOxg"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "i-sokolov"
            queue = "VH"
            summary_template = u"Приемка графов VIDEO_HOSTING {}"
            workflow = {}
            followers = ["fawnd2"]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = None
        dirs = [
            "arcadia/apphost/conf/verticals/VIDEO_HOSTING"
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/vh"
        tag_name = "apphost/conf/vh"

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "apphost": yappy_cfg.YappyTemplateCfg(
                template_name="app-host-video-hosting",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="app-host-video-vh",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                "horizon_agent_config_res_id",
                                "horizon_agent.yaml",
                            ),
                            yappy_cfg.YappyParametrizedResource("stable_branch_res_id", "stable_branch"),
                        ],
                        parent_service="hamster_app_host_man_vh",
                        ignore_instance_spec=True,
                    ),
                ],
            ),
        }
