# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


BUILD_RESOURCE = {"name": "playlist_service", "type": "VH_PLAYLIST_SERVICE_BIN"}
BASE_GENERATION_BUILD_RESOURCE = {"name": "base_generation", "type": "PLAYLIST_BASE_GENERATION_BINARY"}


class VideoHostingPlaylistServiceCfg(configs.ReferenceBranchedConfig):
    name = "video_hosting_playlist_service"
    responsible = "i-sokolov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_task_owner = "VH"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            default_yamake_task = 'KOSHER_YA_MAKE'
            observed_path = "extsearch/video/vh/playlist_service/daemon"

            RESOURCES_TO_RELEASE = [
                jg_job_data.ParentDataDict("component_resources", BUILD_RESOURCE["name"], BUILD_RESOURCE["type"])
            ]

            BASE_GENERATION_RESOURCES_TO_RELEASE = [
                jg_job_data.ParentDataDict("component_resources", BASE_GENERATION_BUILD_RESOURCE["name"], BASE_GENERATION_BUILD_RESOURCE["type"])
            ]

            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            last_run_finished=False,
                            seconds_from_last_run_commit=3600,
                            time_interval_list=[(4, 6)],
                            weekday_list=[2],
                            once_a_day=True,
                        ),
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name=self.default_yamake_task,
                        ctx={
                            "targets": self.observed_path,
                            "result_rt": BUILD_RESOURCE["type"],
                            "result_single_file": True,
                            "arts": "extsearch/video/vh/playlist_service/daemon/playlist_service",
                        },
                        out={BUILD_RESOURCE["type"]: 90},
                    )
                )

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name=self.default_yamake_task,
                        ctx={
                            "targets": "extsearch/video/vh/base_generation/service",
                            "result_rt": BASE_GENERATION_BUILD_RESOURCE["type"],
                            "result_single_file": True,
                            "arts": "extsearch/video/vh/base_generation/service/indexes_dump",
                        },
                        job_params={
                            "job_name_parameter": "BASE_GENERATION"
                        },
                        out={BASE_GENERATION_BUILD_RESOURCE["type"]: 90},
                    )
                )

                branch_part.append(jg_test.JobGraphElementYappyBetaGeneratorBranched(
                    beta_conf_type="vh",
                    job_arrows=jg_job_triggers.JobTriggerBuild(parent_job_data=self.RESOURCES_TO_RELEASE),
                ))

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="VH_GENERATE_PLAYLIST_REQUESTS_FROM_YT",
                    job_params={
                        "job_name_parameter": "GENERATE_REQUESTS",
                    },
                    job_arrows=jg_job_triggers.JobTriggerBuild(parent_job_data=self.RESOURCES_TO_RELEASE),
                    ctx={
                        "yt_cluster": "hahn",
                        "yt_token_vault": "yt_token_for_testenv",
                        "request_log_path": "//logs/vh-playlist-service-logs/1d",
                        "max_request_number": "5000",
                        "yt_logs_limit": "50000",
                        "binary_executor_release_type": "stable"
                    },
                    out={
                        "PLAYLIST_SERVICE_REQUEST_PLAN": 30
                    }
                ))

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="VH_SHOOT_PLAYLIST_SERVICE_WITH_SERVANT_CLIENT",
                    job_params={
                        "job_name_parameter": "SHOOT_BETA",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerGenerateBeta(
                            job_name_parameter="vh",
                            parent_job_data=(
                                jg_job_data.ParentDataCtx(
                                    input_key="beta_name",
                                    output_key="beta_name",
                                )
                            )
                        ),
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="plan_file_vh_http",
                                    output_key="plan_file_vh",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="plan_file_ugc",
                                    output_key="plan_file_ugc",
                                )
                            ),
                            job_name_parameter="GENERATE_REQUESTS"
                        )
                    ),
                    ctx={
                        "yappy_token_vault": "vh_yappy_auth_token",
                        "binary_executor_release_type": "stable"
                    },
                    out={
                        "PLAYLIST_SERVICE_RESPONSES": 30
                    }
                ))

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="VH_SHOOT_PLAYLIST_SERVICE_WITH_SERVANT_CLIENT",
                    job_params={
                        "job_name_parameter": "SHOOT_HAMSTER",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="plan_file_vh_http",
                                    output_key="plan_file_vh",
                                ),
                                jg_job_data.ParentDataOutput(
                                    input_key="plan_file_ugc",
                                    output_key="plan_file_ugc",
                                )
                            ),
                            job_name_parameter="GENERATE_REQUESTS"
                        )
                    ),
                    ctx={
                        "host": "hamster-playlist-service-3.vla.yp-c.yandex.net",
                        "binary_executor_release_type": "stable"
                    },
                    out={
                        "PLAYLIST_SERVICE_RESPONSES": 30
                    }
                ))

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="VH_PLAYLIST_SERVICE_DIFF_RESULTS",
                    job_params={
                        "job_name_parameter": "DIFF_RESULTS_VH",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="plan_file",
                                    output_key="plan_file_vh",
                                ),
                            ),
                            job_name_parameter="GENERATE_REQUESTS"
                        ),
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="beta_responses",
                                    output_key="responses_vh",
                                ),
                            ),
                            job_name_parameter="SHOOT_BETA"
                        ),
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="prod_responses",
                                    output_key="responses_vh",
                                ),
                            ),
                            job_name_parameter="SHOOT_HAMSTER"
                        )
                    ),
                    ctx={
                        "requests_scheme": "http",
                        "binary_executor_release_type": "stable"
                    }
                ))

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="VH_PLAYLIST_SERVICE_DIFF_RESULTS",
                    job_params={
                        "job_name_parameter": "DIFF_RESULTS_UGC",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="plan_file",
                                    output_key="plan_file_ugc",
                                ),
                            ),
                            job_name_parameter="GENERATE_REQUESTS"
                        ),
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="beta_responses",
                                    output_key="responses_ugc",
                                ),
                            ),
                            job_name_parameter="SHOOT_BETA"
                        ),
                        jg_job_triggers.JobTriggerTestBranchCommon(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="prod_responses",
                                    output_key="responses_ugc",
                                ),
                            ),
                            job_name_parameter="SHOOT_HAMSTER"
                        )
                    ),
                    ctx={
                        "requests_scheme": "proto",
                        "binary_executor_release_type": "stable"
                    }
                ))

                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_stage_job_params = None if release_stage == rm_const.ReleaseStatus.stable else {
                        "frequency": (jg_utils.TestFrequency.RUN_N_MINUTES_AFTER_LAST_RUN, 100000000),
                    }
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=[
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=self.RESOURCES_TO_RELEASE
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="BASE_GENERATION",
                                    parent_job_data=self.BASE_GENERATION_RESOURCES_TO_RELEASE
                                ),
                            ]
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_params=release_stage_job_params
                        )
                    )
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        allow_old_releases = True
        allow_robots_to_release_stable = True

        resources_info = [
            # archive with executable file
            configs.ReleasedResourceInfo(
                name="vh_playlist_service",
                resource_name=BUILD_RESOURCE["name"],
                resource_type=BUILD_RESOURCE["type"],
                deploy=[configs.DeployServicesInfo(services=["playlist_service_production"])],
            ),
            configs.ReleasedResourceInfo(
                name="vh_playlist_pumpkin_basegen",
                resource_name=BASE_GENERATION_BUILD_RESOURCE["name"],
                resource_type=BASE_GENERATION_BUILD_RESOURCE["type"],
                deploy=[configs.DeployServicesInfo(services=["playlist_pumpkin_basegen"])],
            ),
        ]
        release_followers_permanent = [
            "i-sokolov"
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "vh": yappy_cfg.YappyTemplateCfg(
                template_name="vh-playlist-service-beta-template",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="video_hosting_playlist_service",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                param_name=BUILD_RESOURCE["name"],
                                local_path=BUILD_RESOURCE["name"]
                            )
                        ],
                        parent_service="playlist_service_production"
                    )
                ]
            )
        }
        working_betas_limit = 2
        wait_for_deploy_time_sec = 60 * 15

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""
        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["frontend-vh"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "i-sokolov"
            queue = "VH"
            summary_template = u"Приемка PlaylistService VIDEO_HOSTING {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "i-sokolov"
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = None
        dirs = [
            "arcadia/extsearch/video/vh/playlist_service",
            "arcadia/extsearch/video/vh/base_generation"
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "playlist_service"
        tag_name = "playlist_service"
