# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class VideoHostingSrcSetupCfg(configs.ReferenceBranchedConfig):
    name = "video_hosting_src_setup"
    responsible = "fawnd2"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "VH"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            default_yamake_task = 'KOSHER_YA_MAKE'

            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrek(
                        next_revision_custom_schedule=jg_utils.CustomSchedule(
                            last_run_finished=False,
                            seconds_from_last_run_commit=3600,
                            time_interval_list=[(4, 6)],
                            weekday_list=[2],
                            once_a_day=True,
                        ),
                    ),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_APP_HOST_SRC_SETUP_VIDEO_HOSTING",
                        ctx={
                            "choose_vertical": "VIDEO_HOSTING",
                            "build_default_src_setup": False,
                            "breakpad_symbols_dumper_resource_id": 61581470,
                            # Very old resource TODO: put it in testenv
                            "release_machine_launch": True,
                            "arc_token_owner": "VH",
                        },
                        out={"APP_HOST_SRC_SETUP_BUNDLE_VIDEO_HOSTING": 90},
                    )
                )
                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_APP_HOST_SRC_SETUP_CONFIG_BUNDLE",
                        build_item="CONFIG",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        ctx={
                            "choose_vertical": "VIDEO_HOSTING",
                            "build_service_resources": True,
                            "build_resources_for_choosen_verticals_only": True,
                        },
                        out={
                            "APP_HOST_SRC_SETUP_CONFIG_BUNDLE_VIDEO_HOSTING": 90,
                        },
                    )
                )
                for vertical, res_suffix in [("video_hosting", "VIDEO_HOSTING")]:
                    branch_part.append(
                        jg_test.JobGraphElementYappyBetaGeneratorBranched(
                            beta_conf_type=vertical,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "src_setup_bundle",
                                            "APP_HOST_SRC_SETUP_BUNDLE_VIDEO_HOSTING",
                                        )
                                    )
                                ),
                                jg_job_triggers.JobTriggerBuild(
                                    job_name_parameter="CONFIG",
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "src_setup_config_res_id",
                                            "APP_HOST_SRC_SETUP_CONFIG_BUNDLE_{}".format(res_suffix),
                                        ),
                                    ),
                                ),
                            ),
                        )
                    )
                sanitize_params = [
                    (
                        "web/src_setup/tests/pseudo_src_setup/shoot",
                        "ASAN_TESTS",
                        "address",
                    ),
                    (
                        "web/src_setup/tests/pseudo_src_setup/shoot",
                        "TSAN_TESTS",
                        "thread",
                    ),
                ]
                for target, name_suffix, sanitize in sanitize_params:
                    branch_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name=self.default_yamake_task,
                            job_params={
                                "job_name_parameter": name_suffix,
                                "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                                "apiargs": {
                                    "requirements": {
                                        "disk_space": 120 * (1024 ** 3),  # 120 Gb
                                    },
                                    "kill_timeout": 5 * 60 * 60,  # 5 hours in seconds
                                }
                            },
                            job_arrows=(
                                jg_arrows.ParamsData(
                                    input_key=sandbox_constants.ARCADIA_URL_KEY,
                                    transform=lambda x, rm_config: "{}/arcadia@{}".format(x.svn_ssh_url, x.revision),
                                ),
                            ),
                            ctx={
                                "targets": target,
                                "test": True,
                                "disable_test_timeout": True,
                                "sanitize": sanitize,
                            },
                        )
                    )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="VH_FRONTEND_JSON_SCHEMA_VALIDATOR",
                        job_params={
                            "job_name_parameter": "VH_VALIDATION_TEST",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="video_hosting",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="host",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster.yandex.ru".format(x),
                                    ),
                                ),
                            ),
                        ),
                        ctx={
                            "binary_executor_release_type": "stable"
                        },
                    ),
                )
                umbrella_arrows = [
                    jg_job_triggers.JobTriggerTestBranchCommon(
                        job_name_parameter="VH_VALIDATION_TEST",
                    )
                ]
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=umbrella_arrows,
                        job_params={
                            "frequency": (jg_utils.TestFrequency.EVERY_N_COMMIT, 1000000),
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        job_arrows=umbrella_arrows,
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_stage_job_params = None if release_stage == rm_const.ReleaseStatus.stable else {
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    }
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "src_setup_bundle",
                                            "APP_HOST_SRC_SETUP_BUNDLE_VIDEO_HOSTING",
                                        )
                                    )
                                )
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_params=release_stage_job_params
                        )
                    )
                return release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="src_setup_bundle",
                    data=ri.SandboxResourceData("APP_HOST_SRC_SETUP_BUNDLE_VIDEO_HOSTING"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("production_src_setup_{}_vh".format(i), tags=["prod"])
                                for i in rm_const.MAIN_LOCATIONS
                            ] + [
                                ri.DeployService("hamster_src_setup_{}_vh".format(i), tags=["hamster"])
                                for i in ["sas", "man"]
                            ]
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("testing_src_setup_vla_vh", tags=["testing"]),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                    ],
                )
            ]

        release_followers_permanent = [
            "i-sokolov",
            "fawnd2",
        ]
        allow_old_releases = True
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "i-sokolov"
            queue = "VH"
            summary_template = u"Приемка Src Setup VIDEO_HOSTING {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "i-sokolov",
                "fawnd2",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "arcadia/web/src_setup/lib/setup/video_hosting",
            "arcadia/web/src_setup/lib/setup/video_hosting_filter_identities",
            "arcadia/web/src_setup/lib/setup/video_hosting_mychannel",
            "arcadia/web/src_setup/lib/setup/video_hosting_recommender"
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "src_setup/video_hosting"
        tag_name = "src_setup/video_hosting"

    class Yappy(yappy_cfg.YappyBaseCfg):
        _template_resources = [
            yappy_cfg.YappyParametrizedResource(
                local_path="SRC_SETUP_BUNDLE.tar.gz", param_name="src_setup_bundle"
            )
        ]

        betas = {
            "video_hosting": yappy_cfg.YappyTemplateCfg(
                template_name="src-setup-video-hosting",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="src-setup-vh",
                        resources=_template_resources,
                        parent_service="hamster_src_setup_man_vh",
                        ignore_instance_spec=True,
                    ),
                ],
            ),
        }
