# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows


class VideoIndexCfg(configs.ReferenceBranchedConfig):
    name = "video_index"
    responsible = "vkap"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "video-index-trunk"
        trunk_task_owner = "VIDEODEV"
        branch_db_template = "video-index-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="VIDEO_BUILD_DOCBASE_BINARIES",
                        build_item="BINARIES",
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 200 * (1024 ** 3),  # 200 Gb
                                },
                                "kill_timeout": 5 * 60 * 60,  # 5 hours in seconds
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="arcadia_url",
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                    ),
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="notify_if_finished",
                                transform=lambda x, rm_config: x.commit_author,
                            ),
                        ),
                        ctx={
                            "ya_timeout": 5 * 3600,
                            "thinlto": False
                        }
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="VIDEO_BUILD_PQ_BUNDLE",
                        build_item="PQ_BUNDLE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="arcadia_url",
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BINARIES",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="BuildTask",
                                    )
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="notify_if_finished",
                                transform=lambda x, rm_config: x.commit_author,
                            ),
                        ),
                        ctx={
                        },
                        out={"VIDEO_INDEX_PQ_BUNDLE": 90},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="VIDEO_BUILD_DOCBASE_BUNDLE",
                        build_item="DOCBASE_BUNDLE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="arcadia_url",
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BINARIES",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="BuildTask",
                                    )
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="notify_if_finished",
                                transform=lambda x, rm_config: x.commit_author,
                            ),
                        ),
                        ctx={
                        },
                        out={"VIDEO_BUNDLE_DOCBASE": 90},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="VIDEO_BUILD_WEBSCRIPTS",
                        build_item="WEBSCRIPTS",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="arcadia_url",
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                    ),
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="notify_if_finished",
                                transform=lambda x, rm_config: x.commit_author,
                            ),
                        ),
                        out={"VIDEO_WEBSCRIPTS_RESOURCE": 90},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="VIDEO_BUILD_INDEX_BUNDLE",
                        build_item="INDEX_BUNDLE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="arcadia_url",
                                        output_key="result_path",
                                        transform=lambda x, params: "{}/arcadia".format(x),
                                    ),
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="BINARIES",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="BuildTask",
                                    )
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="notify_if_finished",
                                transform=lambda x, rm_config: x.commit_author,
                            ),
                        ),
                        ctx={
                        },
                        out={"VIDEO_BUNDLE_INDEX": 90},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="VIDEO_CREATE_TEST_ENV",
                        build_item="DOCBASE_SAMPLE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="DOCBASE_BUNDLE",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="BuildBundleTask",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="WEBSCRIPTS",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="BuildWebscriptsTask",
                                    )
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="notify_if_finished",
                                transform=lambda x, rm_config: x.commit_author,
                            ),
                        ),
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="VIDEO_BUILD_TEST_INDEX",
                        build_item="INDEX_SAMPLE",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="DOCBASE_SAMPLE",
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="BuildBundleTask",
                                        output_key="BuildDocbaseBundleTask",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="BuildWebscriptsTask",
                                        output_key="BuildWebscriptsTask",
                                    ),
                                    jg_job_data.ParentDataCtx(
                                        input_key="yt_prefix",
                                        output_key="yt_prefix",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="INDEX_BUNDLE",
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="BuildIndexBundleTask",
                                    )
                                )
                            ),
                            jg_arrows.ParamsData(
                                input_key="notify_if_finished",
                                transform=lambda x, rm_config: x.commit_author,
                            ),
                        ),
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="DOCBASE_BUNDLE",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="video_docbase_bundle_res_id",
                                        resource_name="VIDEO_BUNDLE_DOCBASE",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="INDEX_BUNDLE",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="video_index_bundle_res_id",
                                        resource_name="VIDEO_BUNDLE_INDEX",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="WEBSCRIPTS",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="video_index_webscripts_res_id",
                                        resource_name="VIDEO_WEBSCRIPTS_RESOURCE",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="PQ_BUNDLE",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="video_pq_bundle_res_id",
                                        resource_name="VIDEO_INDEX_PQ_BUNDLE",
                                    )
                                )
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                    )
                ]
                return default_release_part + release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="Docbase bundle",
                resource_type="VIDEO_BUNDLE_DOCBASE",
                resource_name="video_docbase_bundle_res_id",
                build_ctx_key="arcadia_url",
            ),
            configs.ReleasedResourceInfo(
                name="Index bundle",
                resource_type="VIDEO_BUNDLE_INDEX",
                resource_name="video_index_bundle_res_id",
                build_ctx_key="arcadia_url",
            ),
            configs.ReleasedResourceInfo(
                name="Video index webscripts",
                resource_type="VIDEO_WEBSCRIPTS_RESOURCE",
                resource_name="video_index_webscripts_res_id",
                build_ctx_key="arcadia_url",
            ),
            configs.ReleasedResourceInfo(
                name="Video index pq bundle",
                resource_type="VIDEO_INDEX_PQ_BUNDLE",
                resource_name="video_pq_bundle_res_id",
                build_ctx_key="arcadia_url",
            ),
        ]
        release_followers_permanent = [
            "smalashkevich",
            "tolich",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = []
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "vkap"
            queue = "RELEASEVIDEOIDX"
            queue = "VIDEO"
            summary_template = u"Релиз видеоиндекса {}"
            workflow = {}
            followers = [
                "slobodetskiy",
                "tolich",
                "smalashkevich",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "video/videopoisk/robot/releases/"
        dirs = [
            "arcadia/extsearch/video",
            "arcadia/yweb/video",
        ]
        review_groups = [
            "video-robot",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "video/docbase"
        tag_name = "video/docbase"
