# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.common.constants import constants as common_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows


_NOT_GRANTED_MESSAGE_FORMAT = """Merger {} is not allowed to merge into {}.
Please, contact current release engineer on duty: https://abc.yandex-team.ru/services/runtimevideo/duty/
"""
# https://abc.yandex-team.ru/services/runtimevideo/
_VIDEO_MIDDLE_ABC_GROUP_ID = 1619
_VIDEO_MIDDLE_GROUP_NAME = "VIDEODEV"
_VIDEO_MIDDLE_MAIN_RESPONSIBLE = "alexburkov"
_VIDEO_MIDDLE_RESPONSIBLES = [_VIDEO_MIDDLE_MAIN_RESPONSIBLE, "niketeen", "shaveinikovds"]
_VIDEO_MIDDLE_STARTREK_QUEUE = "VIDMMETARELEASE"


class VideoMiddleCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "video_middle"
    display_name = u"Video Middlesearch"
    responsible = _VIDEO_MIDDLE_MAIN_RESPONSIBLE

    class MergesCfg(configs.ReferenceBranchedConfig.MergesCfg):
        permissions = configs.MergePermissions(
            permission_type=rm_const.PermissionType.ALLOWED,
            people_groups=configs.PeopleGroups(
                staff_groups=None,
                abc_services=[configs.Abc(component_id=_VIDEO_MIDDLE_ABC_GROUP_ID, role_id=None)],
                logins=None,
            ),
        )

        def not_granted_message(self, author, responsible):
            return _NOT_GRANTED_MESSAGE_FORMAT.format(
                author, self.name,
            )

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = _VIDEO_MIDDLE_GROUP_NAME

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _DEFAULT_RESOURCE_TTL = 365

            def _generate_output_resources(self, target_resources):
                return dict([
                    (resource, self._DEFAULT_RESOURCE_TTL) for resource in target_resources
                ])

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                component_to_build_resources = {
                    "VIDEO": [
                        "VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE",
                        "EVLOGDUMP_EXECUTABLE",
                        "EVLOGSAMPLE_EXECUTABLE",
                    ]
                }
                all_resources = []
                for component in component_to_build_resources:
                    all_resources += component_to_build_resources[component]
                all_resources = list(set(all_resources))

                branch_part.append(
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_MIDDLESEARCH_VIDEO",
                        ctx={
                            "target_resources": all_resources,
                            "build_system": common_const.SEMI_DISTBUILD_BUILD_SYSTEM,
                            "notify_if_failed": _VIDEO_MIDDLE_GROUP_NAME,
                            "thinlto": True,
                        },
                        out=self._generate_output_resources(all_resources),
                    )
                )

                for component, target_resources in component_to_build_resources.items():
                    output_resources = self._generate_output_resources(target_resources)
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="BUILD_MIDDLESEARCH_VIDEO",
                            job_params={
                                "job_name_parameter": component,
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataId("copy_from"),
                                    ),
                                ),
                            ),
                            ctx={
                                "target_resources": target_resources,
                                "build_system": common_const.SEMI_DISTBUILD_BUILD_SYSTEM,
                                "notify_if_failed": _VIDEO_MIDDLE_GROUP_NAME,
                                "thinlto": True,
                            },
                            out=output_resources,
                        )
                    )
                beta_params = [
                    ("VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE", "video")
                ]
                for res_type, beta_conf_type in beta_params:
                    branch_part.append(
                        jg_test.JobGraphElementYappyBetaGeneratorBranched(
                            beta_conf_type=beta_conf_type,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "mmeta_web",
                                            res_type,
                                        ),
                                    ),
                                ),
                            ),
                        )
                    )

                # Metrics SLA-project "SLA Release Machine", more info at https://metrics.yandex-team.ru/admin/sla
                MIDDLE_METRICS_SLA_PROJECT = "aa8286386850f0df016874cc48882d44"
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        search_subtype="video",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="checked_beta",
                                        output_key="beta_name",
                                        transform=lambda x, params: "{}.hamster".format(x),
                                    )
                                ),
                                job_name_parameter="VIDEO",
                            )
                        ),
                        ctx={
                            "beta_conf_type": "video",
                            "sample_beta": "priemka-vid.hamster",
                            "scraper_over_yt_pool": "middle_images_priemka",
                            "sla_project": MIDDLE_METRICS_SLA_PROJECT,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="PRIEMKA_ALL_MIDDLESEARCH_BINARIES",
                        job_params={
                            "job_name_parameter": "DAILY_PRIEMKA",
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 1440),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataId(
                                        input_key="build_task_new",
                                    )
                                ),
                            ),
                            jg_arrows.ParamsData("release_number", jg_utils.get_major_release_number),
                            jg_arrows.ParamsData("revision_tested", transform=lambda x, rm_config: x.revision),
                        ),
                        ctx={
                            "set_hamster_config_source": True,
                            "compare_binaries_result_resource_ttl": self._DEFAULT_RESOURCE_TTL,
                            "priemka_cbir": False,
                            "priemka_img": False,
                            "priemka_imgquick": False,
                            "priemka_itditp": False,
                            "priemka_quick": False,
                            "priemka_web": False,
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestXMLSearch(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="beta_url",
                                        output_key="beta_name",
                                        transform=lambda x, params: "https://{}.hamster.yandex.ru".format(x),
                                    )
                                ),
                                job_name_parameter="VIDEO",
                            )
                        ),
                    )
                )

                umbrella_parents = (
                    jg_job_triggers.JobTriggerLaunchMetrics(job_name_parameter="VIDEO"),
                    jg_job_triggers.JobTriggerTestXMLSearch(),
                    jg_job_triggers.JobTriggerActionRelease(
                        job_name_parameter=rm_const.ReleaseStatus.testing,
                    ),
                )

                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedScheduled(
                        job_arrows=umbrella_parents,
                        frequency=(jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 2880),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=umbrella_parents,
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            "component_resources",
                                            "mmeta_video",
                                            "VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE",
                                        ),
                                    ),
                                )
                            ),
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                uppercase_name = self.name.upper()
                tests.update({
                    "_BUILD__BASE": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD__BASE__DEBUG": rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_IMAGES_{}SEARCH".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_VIDEO_{}SEARCH".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_QUICK_{}SEARCH".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_WEB_{}SEARCH".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_BUILD_RELEASE_{}SEARCH_2".format(uppercase_name): rm_const.TestFrequencies.EACH_REV_TEST,
                    "_{}_UMBRELLA_ACCEPT_SCHEDULED".format(uppercase_name):
                        rm_const.TestFrequencies.EVERY_TWO_DAYS_TEST,
                })
                return tests

            @property
            def ignore_match(self):
                return super(self.__class__, self).ignore_match + [
                    "BUILD_MIDDLESEARCH_FOR_PRIEMKA",
                    "PERFORMANCE_MIDDLESEARCH_SINGLE_HOST_CPROXY",
                    "INT_PERFORMANCE_SINGLE_HOST_PROFILE",
                    "MMETA_PERFORMANCE_SINGLE_HOST_PROFILE",
                    "FUZZY_TEST_MIDDLESEARCH",
                    "BUILD_MIDDLESEARCH_FUZZER",
                    "PREPARE_WEB_MIDDLE_FUZZY_INPUT",
                ]  # SEARCH-4376

            @property
            def ignore_prefix(self):
                """List of test prefixes which should be ignored in branch db"""
                return super(self.__class__, self).ignore_prefix + [
                    "WEB_MMETA_FUZZY",
                ]

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 4
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = True
        release_followers_permanent = _VIDEO_MIDDLE_RESPONSIBLES
        responsible = configs.Responsible(
            abc=configs.Abc(component_id=_VIDEO_MIDDLE_ABC_GROUP_ID),
            login=_VIDEO_MIDDLE_MAIN_RESPONSIBLE
        )

        @property
        def releasable_items(self):
            vidmmeta_prod = ["production_vidmmeta_{}".format(i) for i in rm_const.MAIN_LOCATIONS]
            vidmmeta_hamster = ["production_hamster_vidmmeta_{}".format(i) for i in rm_const.MAIN_LOCATIONS]
            vidmmeta_hamster_prs = ["production_hamster_prs_vidmmeta_{}".format(i) for i in rm_const.MAIN_LOCATIONS]
            vidmmeta_pip = "video_mmeta_pip"
            vhs_mmeta = "production_vhs_mmeta"
            vhs_mmeta_hamster = "hamster_vhs_mmeta"
            return [
                ri.ReleasableItem(
                    name="mmeta_video",
                    data=ri.SandboxResourceData("VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService(i, tags=["prod"]) for i in vidmmeta_prod
                            ] + [
                                ri.DeployService(i, tags=["hamster"]) for i in vidmmeta_hamster
                            ] + [
                                ri.DeployService(i, tags=["hamster"]) for i in vidmmeta_hamster_prs
                            ] + [
                                ri.DeployService(vhs_mmeta, tags=["prod"]),
                                ri.DeployService(vhs_mmeta_hamster, tags=["hamster"]),
                                ri.DeployService(vidmmeta_pip, tags=["pip"]),
                            ],
                            stage=rm_const.ReleaseStatus.stable
                        ),
                        ri.SandboxInfo(stage=rm_const.ReleaseStatus.testing),
                    ],
                ),
            ]

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            mailing_list = []
            for responsible in _VIDEO_MIDDLE_RESPONSIBLES:
                mailing_list.append(responsible + "@yandex-team.ru")

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = []
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/joinchat/PDcQMb5H9WEwNzky"

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = _VIDEO_MIDDLE_MAIN_RESPONSIBLE
            queue = _VIDEO_MIDDLE_STARTREK_QUEUE
            dev_queue = _VIDEO_MIDDLE_STARTREK_QUEUE
            summary_template = u"Приемка среднего метапоиска видео {}"
            components = u"Средний метапоиск видео".encode("utf-8")
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = _VIDEO_MIDDLE_RESPONSIBLES
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 4
            nanny_reports = False

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "video/middlesearch/releases/"
        ya_make_targets = [
            "arcadia/search/daemons/ranking_middlesearch",
            "arcadia/search/meta",
            "arcadia/search/web/rearrs_middle",
        ]
        observed_paths = [
            # INCLUDEd from search/web/rearrs_middle/antidup/ya.make
            "arcadia/search/web/rearrs_upper/rearrange.dynamic/antidup/text_source",
        ]
        testenv_dbs = False

    class MetricsCfg(configs.ReferenceBranchedConfig.MetricsCfg):
        run_bisect = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        allow_autobranches = False

    class Yappy(yappy_cfg.YappyBaseCfg):
        _mmeta_res = yappy_cfg.YappyParametrizedResource(
            local_path="mmeta.executable",
            param_name="mmeta_web",
            checkconfig_name="mmiddle-linux-bin-md5",
        )
        _mmeta_models_res = yappy_cfg.YappyStaticResource(local_path="mmeta.models", manage_type="BC_DEFAULT")

        betas = {
            "video": yappy_cfg.YappyTemplateCfg(
                template_name="mmeta-video",
                patches=[
                    yappy_cfg.YappyTemplatePatch(patch_dir="mmeta-video", resources=[_mmeta_res, _mmeta_models_res]),
                ],
                new_yappy=True,
            ),
        }
