# -*- coding: utf-8 -*-

import os
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg import flow as jg_flow
from sandbox.projects.release_machine.components.config_core.jg.graph import base as graph_base
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import release as release_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import IceFlamePatched
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components.configs.video_src_setup import VideoSrcSetupTestsBundle


# ya make tasks
BINARY_PATH = "web/src_setup/daemons/vertical/VIDEO/src_setup"
CONFIG_PATH = "web/src_setup/conf/vertical/VIDEO/static_config"
EVENT_LOG_DUMP_PATH = "web/src_setup/tools/event_log_dump"
ASAN_TSAN_DIFF_TESTS_PATH = "web/src_setup/tests/pseudo_src_setup/VIDEO"

# global variables
CHAT_NAME = "src_setup_releases_video::telegram"
PARENT_SERVICE = "src_setup_video_beta_template"  # for iceflame and yappy


class VideoSrcSetupCfg(configs.ReferenceCIConfig):
    name = "video_src_setup"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="runtimevideo"),
        login='jon2205'
    )

    # metrics launch
    component_group = "reference_component_metricsed"

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):
        # JG params and stages init
        add_beta_generator = "video"

        @jg_flow.release_flow(stages=basic_build_presets.JOINED_BUILD_RELEASE_FLOW_STAGES)
        def release(self):
            graph = super(self.__class__, self).release(self)

            main_stage_entry_cube = graph.get("main_graph_entry")
            beta_cube = graph.get("generate_beta__video_src_setup__video")
            release_entry_cube = graph.get("release_stage_entry")

            #  tests init
            tests = VideoSrcSetupTestsBundle.get_bundle(
                build_tests_target_path=ASAN_TSAN_DIFF_TESTS_PATH,
                build_tests_needs=[main_stage_entry_cube],
                beta_cube=beta_cube,
                soy_pool="src_setup_web_priemka",
            )

            # add cubes to graph
            for test in tests:
                release_entry_cube.add_requirement(test)
                graph.add(test)

            return graph

        # activate Morty release
        def _get_release_cubes_for_deploy_system(self, deploy_system, where, releasable_items, graph, build):
            return [
                release_cubes.ScheduleRelease(
                    name="release_{}_{}".format(where, deploy_system),
                    component_name=self.component_name,
                    where_to_release=where,
                    flows=["deploy"],
                    warden_component_name="src_setup",
                    warden_parent_component_name="video",
                    deploy_system=deploy_system,
                    schedule_mode="create_and_schedule",
                    input=jg_cube.CubeInput(
                        component_resources={
                            ri.name: build.output.resources[ri.data.resource_type].first().id
                            for ri in releasable_items
                        },
                    ),
                    manual=self.release_manually,
                ),
            ]

        @jg_flow.register_flow(title="Run IceFlame")
        def run_iceflame(self):
            return graph_base.Graph([IceFlamePatched(VideoSrcSetupCfg.name, "video_src_setup_binary", PARENT_SERVICE, "src_setup.conf")])

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = BINARY_PATH
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            os.path.join(BINARY_PATH, "**"),
            os.path.join(CONFIG_PATH, "**"),
        ]

    class Releases(configs.ReferenceCIConfig.Releases):

        allow_old_releases = True
        allow_robots_to_release_stable = True

        @property
        def releasable_items(self):
            def release_it(name, resource_type, dst_path, target, artifact_name, deploy_infos):
                return ri.ReleasableItem(
                    name,
                    data=ri.SandboxResourceData(resource_type, dst_path=dst_path),
                    build_data=ri.BuildData(
                        target=target,
                        artifact=os.path.join(target, artifact_name),
                    ),
                    deploy_infos=deploy_infos,
                )

            hamster_services = [
                "hamster_src_setup_sas_video_yp",
                "hamster_src_setup_man_video_yp",
                "hamster_src_setup_vla_video_yp",
            ]

            production_services = [
                "production_src_setup_sas_video_yp",
                "production_src_setup_man_video_yp",
                "production_src_setup_vla_video_yp",
            ]

            release_deploy_infos = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService(service, tags=["hamster"]) for service in hamster_services
                    ] + [
                        ri.DeployService(service, tags=["production"]) for service in production_services
                    ]
                ),
            ]  # (NEED CHANGES) add prod services

            return [
                release_it(
                    name="video_src_setup_binary",
                    resource_type="VIDEO_SRC_SETUP_BINARY",
                    dst_path="src_setup",
                    target=BINARY_PATH,
                    artifact_name="src_setup",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="video_src_setup_config",
                    resource_type="VIDEO_SRC_SETUP_CONFIG",
                    dst_path="config.json",
                    target=CONFIG_PATH,
                    artifact_name="config.json",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="video_src_setup_event_log_dump",
                    resource_type="SRC_SETUP_EVENT_LOG_DUMP",
                    dst_path="event_log_dump",
                    target=EVENT_LOG_DUMP_PATH,
                    artifact_name="event_log_dump",
                    deploy_infos=release_deploy_infos,
                ),
                ri.DynamicReleasableItem(
                    name="scheduled_bundle",
                    data=ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    deploy_infos=[ri.NannyDeployInfo()],
                ),
            ]

    class Yappy(configs.ReferenceCIConfig.Yappy):
        betas = {
            "video": yappy_cfg.YappyTemplateCfg(
                template_name="src-setup-video-ci",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="src-setup-video-ci",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="src_setup",
                                param_name="video_src_setup_binary",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="event_log_dump",
                                param_name="video_src_setup_event_log_dump",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="config.json",
                                param_name="video_src_setup_config",
                            ),
                        ],
                        parent_service=PARENT_SERVICE,
                    ),
                ],
            ),
        }

    class Notify(configs.ReferenceCIConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="NewBetaGeneration",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name=CHAT_NAME,
                message_template_file="notifications/src_setup/ticket_history.html",
                pin=True,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="ticket_history_data.ticket_history_latest_status",
                            operator="TEXT_EXACTLY_IS",
                            value="open",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="ci_job_instance_id.job_id",
                            operator="TEXT_EXACTLY_IS",
                            value="create_startrek_ticket",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="ci_job_context.version_info.minor",
                            operator="TEXT_EXACTLY_IS",
                            value="",
                        ),
                    ],
                    join_strategy="AND",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="MetaTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="AND",
                ),
                message_template_file="notifications/src_setup/meta_test.html",
            ),
            rm_notifications.Notification(
                event_type="GenericTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="AND",
                ),
                message_template_file="notifications/src_setup/generic_test.html",
            ),
            rm_notifications.Notification(
                event_type="AcceptanceTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="OR",
                ),
            ),
        ]

        class Telegram(configs.ReferenceCIConfig.Notify.Telegram):
            chats = [CHAT_NAME]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/+Heywhs4BCf1hOGUy"

        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):  # (NEED CHANGES)
            assignee = "jon2205"
            queue = "VIDSETUPRELEASE"
            dev_queue = "VIDSETUPRELEASE"
            summary_template = u"Приемка Video Src Setup {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "jon2205",
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 7

            @property
            def banned_people(self):
                return super(self.__class__, self).banned_people | {"zhshishkin"}

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        observed_paths = [
            "arcadia/web/src_setup",
            "arcadia/search/begemot/rules/src_setup"
        ]

        use_previous_branch_as_baseline = True

    class MetricsCfg(configs.ReferenceCIConfig.MetricsCfg):
        limit_s = None

    class ReleaseViewer(configs.ReferenceCIConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 7
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]
