# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class VideobassCfg(configs.ReferenceBranchedConfig):
    name = "videobass"
    responsible = "akormushkin"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "SMARTTV"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="ALICE_EVO_UE_2_E",
                    job_params={
                        "job_name_parameter": "ALICE_EVO_UE_2_E",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "force_start": True,
                        "megamind_url": "http://vins.hamster.alice.yandex.net/speechkit/app/pa/"
                                        "?srcrwr=Video:rc.video-scenario.alice.yandex.net:80"
                                        "&srcrwr=VideoCommand:rc.video-scenario.alice.yandex.net:80"
                                        "&srcrwr=VideoTrailer:rc.video-scenario.alice.yandex.net:80"
                                        "&srcrwr=VIDEO_PROXY:rc.video-scenario.alice.yandex.net:80",
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="release_ticket",
                                    output_key="release_ticket",
                                ),
                            )
                        ),
                        jg_job_triggers.JobTriggerRelease(job_name_parameter=rm_const.ReleaseStatus.testing),
                    ),
                ))

                branch_part.append(jg_test.JobGraphElementTestBranchCommon(
                    task_name="ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                    job_params={
                        "job_name_parameter": "ALICE_EVO_INTEGRATION_TESTS_WRAPPER",
                        "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                    },
                    ctx={
                        "launch_type": "videobass",
                        "repeat_failed_test": True,
                        "run_call_owner_subtask": True,
                        "test_filters": "video",
                        "megamind_url": "http://vins.hamster.alice.yandex.net/speechkit/app/pa/"
                                        "?srcrwr=Video:rc.video-scenario.alice.yandex.net:80"
                                        "&srcrwr=VideoCommand:rc.video-scenario.alice.yandex.net:80"
                                        "&srcrwr=VideoTrailer:rc.video-scenario.alice.yandex.net:80"
                                        "&srcrwr=VIDEO_PROXY:rc.video-scenario.alice.yandex.net:80",
                    },
                    job_arrows=(
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput(
                                    input_key="release_ticket",
                                    output_key="release_ticket",
                                ),
                            )
                        ),
                        jg_job_triggers.JobTriggerRelease(job_name_parameter=rm_const.ReleaseStatus.testing),
                    ),
                ))

                return branch_part

            @property
            def _prerelease(self):
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="BASS_REGRESS_TESTS_TASK",
                        job_params={
                            "job_name_parameter": "TESTPALM_TEST",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerStartrek(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="target_ticket",
                                        output_key="startrek_issue",
                                        transform=lambda x, params: "{}".format(x),
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "target_service": "VIDEOBASS",
                            "testsuite": "alice",
                        },
                    ),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="TESTPALM_TEST",
                            )
                        )
                    ),
                ]

            _preset = jg_presets.SinglePackagePreset(
                build_task_name="BUILD_PROTOCOL_VIDEO_SCENARIO_PACKAGE",
                build_ctx={"raw_package": True},
                package_names="alice/bass/packages/bass_package.json",
                build_apiargs={"requirements": {"disk_space": 112640}},
                deploy_system=rm_const.DeploySystem.nanny.name,
                use_compression=False,
                release_ctx={"wait_for_deploy": True},
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable),
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing, jg_utils.CheckEachCommit()),
                ],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="bass_package",
                    data=ri.SandboxResourceData("PROTOCOL_VIDEO_SCENARIO_PACKAGE", ttl=90),
                    deploy_infos=[
                        ri.single_nanny_service("protocol-video-scenario-man"),
                        ri.single_nanny_service("protocol-video-scenario-rc", stage=rm_const.ReleaseStatus.testing),
                    ],
                ),
            ]

        release_followers_permanent = [
            "akormushkin",
            "pazus",
        ]
        allow_robots_to_release_stable = True
        allow_old_releases = {
            rm_const.ReleaseStatus.testing: False,
            rm_const.ReleaseStatus.stable: True,
        }

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        class Mail(configs.ReferenceBranchedConfig.Notify.Mail):
            """Mail notifications configuration"""
            mailing_list = [
                "akormushkin@yandex-team.ru",
                "pazus@yandex-team.ru",
            ]

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "akormushkin"
            queue = "VIDEOBASSREL"
            dev_queue = "SMARTTVBACKEND"
            summary_template = u"Релиз VideoBass {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "akormushkin",
                "pazus",
            ]
            add_commiters_as_followers = False
            deadline = 7
            hide_commits_under_cut = True
            important_changes_limit = 100

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "video/Stancija/changelogs"
        observed_paths = [
            "arcadia/alice/bass",
            "arcadia/alice/library/video_common"
        ]
