# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class VideorecomBaseCfg(configs.ReferenceBranchedConfig):
    display_name = "VideoRecom Base"
    name = "videorecom_base"
    responsible = "aykeron"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "VIDEORECOM"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part

                def arcadia_url_new_tag_arrow(input_key="arcadia_url"):
                    return jg_arrows.ParentsData(
                        input_key=input_key,
                        triggers=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput("result_path", "result_path"),
                                ),
                            ),
                        ),
                        transform=lambda result_path: "{}/arcadia".format(result_path),
                    )

                branch_part = [
                    jg_build.JobGraphElementBuildBranched(
                        task_name="DJ_BUILD_SHARD_2_RESOURCE_BUNDLE",
                        build_item="DJ_SHARD_2_BUNDLE",
                        out={"VHS_DJ_SHARD_2_RESOURCE_BUNDLE": 30},
                        job_arrows=(
                            arcadia_url_new_tag_arrow("arcadia_root_url"),
                        ),
                        ctx={
                            "bundle_resource_type": "VHS_DJ_SHARD_2_RESOURCE_BUNDLE",

                            "recommender_config_build_from_arcadia": True,
                            "recommender_config_arcadia_path": "vh/recommender/configs/docs/dj_vhs_recommender/recommender.conf",

                            "shard_builder_config_build_from_arcadia": True,
                            "shard_builder_config_arcadia_path": "vh/recommender/configs/docs/dj_vhs_recommender/builder.conf",

                            "attributes_calcer_config_build_from_arcadia": True,
                            "attributes_calcer_config_arcadia_path": "vh/recommender/configs/docs/dj_vhs_recommender/attributes_calcer.conf",

                            "custom_build_from_arcadia": True,
                            "custom_arcadia_path":
                                [
                                    "vh/recommender/configs/docs/dj_vhs_recommender/grouping.conf",
                                    "vh/recommender/configs/docs/resources/ban_list",
                                    "vh/recommender/configs/docs/resources/configs",
                                    "vh/recommender/configs/docs/resources/thread_pool",
                                    "vh/prod_data/recommender/models/docs",
                                    "vh/prod_data/recommender/models/entity"
                                ]
                        },
                    ),
                    jg_build.JobGraphElementBuildBranched(
                        task_name="DJ_BUILD_SHARD_2_RESOURCE_BUNDLE",
                        build_item="DOC2DOC_DJ_SHARD_2_BUNDLE",
                        out={"DOC_2DOC_DJ_SHARD_2_RESOURCE_BUNDLE": 30},
                        job_arrows=(
                            arcadia_url_new_tag_arrow("arcadia_root_url"),
                        ),
                        ctx={
                            "bundle_resource_type": "DOC_2DOC_DJ_SHARD_2_RESOURCE_BUNDLE",

                            "recommender_config_build_from_arcadia": True,
                            "recommender_config_arcadia_path": "vh/recommender/configs/docs/dj_video_doc2doc/recommender.conf",

                            "shard_builder_config_build_from_arcadia": True,
                            "shard_builder_config_arcadia_path": "vh/recommender/configs/docs/dj_video_doc2doc/builder.conf",

                            "attributes_calcer_config_build_from_arcadia": True,
                            "attributes_calcer_config_arcadia_path": "vh/recommender/configs/docs/dj_video_doc2doc/attributes_calcer.conf",

                            "custom_build_from_arcadia": True,
                            "custom_arcadia_path":
                                [
                                    "vh/recommender/configs/docs/dj_video_doc2doc/grouping.conf",
                                    "vh/recommender/configs/docs/resources/ban_list",
                                    "vh/recommender/configs/docs/resources/configs",
                                    "vh/recommender/configs/docs/resources/thread_pool",
                                    "vh/prod_data/recommender/models/docs"
                                ]
                        },
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_MAKE_RELEASE_TO_NANNY",
                        build_item="DJ_RTY_BINARY",
                        ctx={
                            "targets": "dj/tools/saas_rty",
                            "result_rt": "VHS_DJ_RTYSERVER_BIN",
                            "arts": "dj/tools/saas_rty/saas_rty",
                            "checkout": True,
                            "result_single_file": True,
                        },
                        out={"VHS_DJ_RTYSERVER_BIN": 30},
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release

                release_part = []
                release_stage = rm_const.ReleaseStatus.stable

                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=release_stage,
                    job_arrows=(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="DJ_SHARD_2_BUNDLE",
                            parent_job_data=jg_job_data.ParentDataDict(
                                "component_resources",
                                "dj_shard_2_bundle",
                                "VHS_DJ_SHARD_2_RESOURCE_BUNDLE"
                            ),
                        ),
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="DOC2DOC_DJ_SHARD_2_BUNDLE",
                            parent_job_data=jg_job_data.ParentDataDict(
                                "component_resources",
                                "doc2doc_dj_shard_2_bundle",
                                "DOC_2DOC_DJ_SHARD_2_RESOURCE_BUNDLE"
                            ),
                        ),
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="DJ_RTY_BINARY",
                            parent_job_data=jg_job_data.ParentDataDict(
                                "component_resources",
                                "dj_rty_binary",
                                "VHS_DJ_RTYSERVER_BIN"
                            ),
                        ),
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                                jg_job_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                                jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                            ),
                        ),
                    ),
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=release_stage,
                ))

                return default_release_part + release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "aykeron"
            queue = "VIDEORECOMREL"
            summary_template = "Релиз Videorecom Base {}"
            followers = [
                "aykeron",
                "msvvitaly",
            ]
            add_commiters_as_followers = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/dj/lib/recommender_components",
            "arcadia/dj/lib/basesearch",
            "arcadia/vh/recommender/configs/docs",
            "arcadia/vh/prod_data/recommender/models",
        ]
        wiki_page = "video/vhs/components/base/releases/"

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = True

        stable_deploy_services = [configs.DeployServicesInfo(services=[
            ri.DeployService("saas_yp_dj_vhs_recommender"),
            ri.DeployService("saas_yp_dj_vhs_recom_rt")
        ])]
        resources_info = [
            configs.ReleasedResourceInfo(
                name="dj_shard_2_bundle",
                resource_type="VHS_DJ_SHARD_2_RESOURCE_BUNDLE",
                build_ctx_key="arcadia_root_url",
                deploy=stable_deploy_services,
            ),
            configs.ReleasedResourceInfo(
                name="doc2doc_dj_shard_2_bundle",
                resource_type="DOC_2DOC_DJ_SHARD_2_RESOURCE_BUNDLE",
                build_ctx_key="arcadia_root_url",
                deploy=stable_deploy_services,
            ),
            configs.ReleasedResourceInfo(
                name="dj_rty_binary",
                resource_type="VHS_DJ_RTYSERVER_BIN",
                deploy=stable_deploy_services,
            ),
        ]

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=res_info.name,
                    data=ri.SandboxResourceData(res_info.resource_type, build_ctx_key=res_info.build_ctx_key),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("saas_yp_dj_vhs_recommender"),
                                ri.DeployService("saas_yp_dj_vhs_recom_rt")
                            ]
                        ),
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("saas_cloud_dj_vhs_recommender_prestable"),
                                ri.DeployService("saas_yp_dj_vhs_recom_rt_p"),
                                ri.DeployService("saas_yp_dj_video_doc2doc_p")
                            ],
                            rm_const.ReleaseStatus.testing
                        )
                    ],
                ) for res_info in self.resources_info
            ]
