# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class VideorecomFreshProfileServerCfg(configs.ReferenceBranchedConfig):
    display_name = "VideoRecom Fresh Profile Server"
    name = "videorecom_fps"
    responsible = "tkachenkod"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "VIDEORECOM"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part

                def arcadia_url_new_tag_arrow(input_key="arcadia_url"):
                    return jg_arrows.ParentsData(
                        input_key=input_key,
                        triggers=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput("result_path", "result_path"),
                                ),
                            ),
                        ),
                        transform=lambda result_path: "{}/arcadia".format(result_path),
                    )

                branch_part = [
                    jg_build.JobGraphElementBuildBranched(
                        task_name="VIDEO_RELEASE_FPSCONFIG",
                        build_item="FPS_CONFIG",
                        out={"VIDEO_FRESH_PROFILE_SERVER_CONFIG": 30},
                        job_arrows=(arcadia_url_new_tag_arrow()),
                    ),
                    jg_build.JobGraphElementBuildBranched(
                        task_name="VIDEO_VIDEOHUB_CREATE_DJ_BUNDLE",
                        build_item="FPS_RULE_BUNDLE",
                        out={"VIDEO_VIDEOHUB_DJ_CONFIG_BUNDLE": 30},
                        job_arrows=(
                            arcadia_url_new_tag_arrow("videohub_arcadia_url"),
                            arcadia_url_new_tag_arrow("entity_arcadia_url"),
                        ),
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_MAKE_RELEASE_TO_NANNY",
                        build_item="FPS_BINARY",
                        ctx={
                            "targets": "extsearch/video/daemons/fresh_profile_server",
                            "result_rt": "VIDEO_BIN_FRESH_PROFILE_SERVER",
                            "arts": "extsearch/video/daemons/fresh_profile_server/fresh_profile_server",
                            "checkout": True,
                            "result_single_file": True,
                        },
                        out={"VIDEO_BIN_FRESH_PROFILE_SERVER": 30},
                    ),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="VIDEO_TEST_FRESH_PROFILE_SERVER",
                        job_params={
                            "job_name_parameter": "VIDEO_TEST_FRESH_PROFILE_SERVER",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="FPS_BINARY",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource("fps_resource",  "VIDEO_BIN_FRESH_PROFILE_SERVER")
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="FPS_CONFIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataResource("config_resource",  "VIDEO_FRESH_PROFILE_SERVER_CONFIG")
                                )
                            ),
                            jg_arrows.ParentsData(
                                input_key="custom_files",
                                triggers=(
                                    jg_job_triggers.JobTriggerBuild(
                                        job_name_parameter="FPS_RULE_BUNDLE",
                                        parent_job_data=(
                                            jg_job_data.ParentDataResource("config_id",  "VIDEO_VIDEOHUB_DJ_CONFIG_BUNDLE")
                                        )
                                    ),
                                ),
                                transform=lambda config_id: {config_id: "tmp"},
                            )
                        )
                    ),
                    jg_test.JobGraphElementActionRunAcceptanceBranched(
                        job_arrows=(jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="VIDEO_TEST_FRESH_PROFILE_SERVER")),
                        frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release

                release_part = []
                release_stage = rm_const.ReleaseStatus.stable

                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=release_stage,
                    job_arrows=(
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="FPS_CONFIG",
                            parent_job_data=jg_job_data.ParentDataDict(
                                "component_resources",
                                "fps_config",
                                "VIDEO_FRESH_PROFILE_SERVER_CONFIG"
                            ),
                        ),
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="FPS_RULE_BUNDLE",
                            parent_job_data=jg_job_data.ParentDataDict(
                                "component_resources",
                                "fps_rule_bundle",
                                "VIDEO_VIDEOHUB_DJ_CONFIG_BUNDLE"
                            ),
                        ),
                        jg_job_triggers.JobTriggerBuild(
                            job_name_parameter="FPS_BINARY",
                            parent_job_data=jg_job_data.ParentDataDict(
                                "component_resources",
                                "fps_binary",
                                "VIDEO_BIN_FRESH_PROFILE_SERVER"
                            ),
                        ),
                        jg_job_triggers.JobTriggerNewTag(
                            parent_job_data=(
                                jg_job_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                                jg_job_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                                jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                            ),
                        ),
                    ),
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=release_stage,
                ))

                return default_release_part + release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "tkachenkod"
            queue = "VIDEORECOMREL"
            summary_template = "Релиз Fresh Profile Server {}"
            followers = [
                "tkachenkod",
                "msvvitaly",
            ]
            add_commiters_as_followers = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/entity/recommender/config",
            "arcadia/extsearch/video/daemons/fresh_profile_server",
            "arcadia/extsearch/video/quality/recommender/dj/rules",
            "arcadia/dj/lib/processing/online/fresh_profile_server",
        ]
        wiki_page = "video/vhs/components/fresh-profile-server/releases/"

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_old_releases = True

        stable_deploy_services = [configs.DeployServicesInfo(services=[
            "{}-vitrina-fresh-profile-server-yp".format(i) for i in rm_const.MAIN_LOCATIONS
        ])]
        resources_info = [
            configs.ReleasedResourceInfo(
                name="fps_config",
                resource_type="VIDEO_FRESH_PROFILE_SERVER_CONFIG",
                build_ctx_key="arcadia_url",
                deploy=stable_deploy_services,
            ),
            configs.ReleasedResourceInfo(
                name="fps_rule_bundle",
                resource_type="VIDEO_VIDEOHUB_DJ_CONFIG_BUNDLE",
                build_ctx_key="videohub_arcadia_url",
                deploy=stable_deploy_services,
            ),
            configs.ReleasedResourceInfo(
                name="fps_binary",
                resource_type="VIDEO_BIN_FRESH_PROFILE_SERVER",
                deploy=stable_deploy_services,
            ),
        ]

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=res_info.name,
                    data=ri.SandboxResourceData(res_info.resource_type, build_ctx_key=res_info.build_ctx_key),
                    deploy_infos=[
                        ri.NannyDeployInfo([
                            ri.DeployService("{}-vitrina-fresh-profile-server-yp".format(i))
                            for i in rm_const.MAIN_LOCATIONS
                        ]),
                        ri.NannyDeployInfo(
                            ri.DeployService("vla_vitrina_fresh_profile_server_dev_yp"),
                            rm_const.ReleaseStatus.testing
                        )
                    ],
                ) for res_info in self.resources_info
            ]
