# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows

RESOURCES = [
    "HORIZON_AGENT_CONFIG_VOICE",
    "APP_HOST_STABLE_BRANCH_VOICE",
]


class VoiceGraphsCfg(configs.ReferenceBranchedConfig):
    name = "voice_graphs"

    # TODO: Set Component responsible
    responsible = "paxakor"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "VOICESERV_RELEASERS"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementBuildBranched(
                        task_name="BUILD_HORIZON_AGENT_CONFIG",
                        ctx={
                            "vertical": "VOICE"
                        },
                        out={
                            resource: 14 for resource in RESOURCES
                        }
                    ),
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="uniproxy",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "stable_branch",
                                        "APP_HOST_STABLE_BRANCH_VOICE",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "horizon_agent",
                                        "HORIZON_AGENT_CONFIG_VOICE",
                                    ),
                                ),
                            ),
                            jg_arrows.ParamsData(
                                input_key="patch_name",
                                transform=lambda x, rm_config: str(jg_utils.get_major_release_number(x, rm_config)),
                            )
                        ),
                        ctx={"beta_name_source": "STRING"},
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=[
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "app_host_stable_branch_voice",
                                        "APP_HOST_STABLE_BRANCH_VOICE"
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "horizon_agent_config_voice",
                                        "HORIZON_AGENT_CONFIG_VOICE"
                                    )
                                ],
                            ),
                            jg_job_triggers.JobTriggerNewTag([
                                jg_job_data.ParentDataOutput('major_release_num', 'branch_number_for_tag'),
                                jg_job_data.ParentDataOutput('minor_release_num', 'new_tag_number'),
                            ]),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable
                    )
                ]
                return default_release_part + release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[ri.single_nanny_service("wsproxy-man")],
                ) for resource in RESOURCES
            ]

        release_followers_permanent = [
            # TODO: Set Release Request Followers
            "paxakor",
        ]
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/voice"
        tag_name = "apphost/conf/voice"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "paxakor"
            queue = "ALICERELEASE"
            summary_template = u"Приемка графов VOICE {}"
            # TODO: Set Ticket followers for all VOICE graphs releases
            followers = [
                "paxakor",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "voicetechnology/dev/serverinfr/apphostgraphs/releases"
        ya_make_targets = [
            "arcadia/apphost/conf/verticals/VOICE",
        ]

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "uniproxy": yappy_cfg.YappyTemplateCfg(
                template_name="alice-uniproxy-voice-graphs",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="alice-uniproxy-voice-graphs",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                param_name="stable_branch",
                                local_path="stable_branch"
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                param_name="horizon_agent",
                                local_path="horizon-agent.nora.yaml"
                            )
                        ],
                        parent_service="wsproxy-vla",
                        ignore_instance_spec=False,
                    )
                ],
            ),
        }

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = "paxakor"
            queue = "ALICERELEASE"
            dev_queue = "ALICE"
            summary_template = u"Приемка графов VOICE {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "av-kotikov",
                "danichk",
                "paxakor",
            ]
            add_commiters_as_followers = False
            deadline = 7
            hide_commits_under_cut = True
            important_changes_limit = 100
