# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets


class WatchLogCfg(configs.ReferenceCIConfig):
    name = "watch_log"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="searchpers"),
        login="skorodumov-s",
    )

    class JG(basic_build_presets.SingleBuildYaPackageJGCfg):
        release_manually = False

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "quality/personalization/big_rt/watch_log"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-PERS"

        ya_make_abs_paths_glob = [
            "quality/personalization/big_rt/watch_log/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="watch_log_resharder_files_package",
                    build_data=ri.BuildData(
                        target="quality/personalization/big_rt/watch_log/resharder/bin/pkg.json",
                    ),
                    data=ri.SandboxResourceData("WATCH_LOG_RESHARDER_FILES_PACKAGE"),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("searchpers_big_rt")),
                    ],
                ),
                ri.ReleasableItem(
                    name="watch_log_parser_files_package",
                    build_data=ri.BuildData(
                        target="quality/personalization/big_rt/watch_log/parser/pkg.json",
                    ),
                    data=ri.SandboxResourceData("WATCH_LOG_PARSER_FILES_PACKAGE"),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("searchpers_big_rt")),
                    ],
                ),
                ri.ReleasableItem(
                    name="aggregator_vcdiff_package_watch_log",
                    build_data=ri.BuildData(
                        target="quality/personalization/big_rt/aggregator_vcdiff/pkg.json",
                    ),
                    data=ri.SandboxResourceData("AGGREGATOR_VCDIFF_PACKAGE_WATCH_LOG"),
                    deploy_infos=[
                        ri.YaDeployInfo(ri.DeployService("searchpers_big_rt")),
                    ],
                ),
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        use_release_task_as_ti_task_type = True

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "x33nu"
            queue = "SEARCHPERSREL"
            dev_queue = "SEARCHPERS"
            summary_template = u"Приемка WatchLog {}"
            workflow = {}
            followers = [
                "skorodumov-s",
            ]
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = None
        dirs = [
            "quality/personalization/big_rt/watch_log",
        ]
