# -*- coding: utf-8 -*-
import os
import re

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.common import constants as sandbox_constants
import sandbox.projects.release_machine.helpers.arcadia as rm_arc
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


#                                               weather         duty
WEATHER_RESPONSIBLE_ABC = configs.Abc(component_id=105, schedule_slug="main_prod_duty")
WEATHER_RESPONSIBLE = configs.Responsible(abc=WEATHER_RESPONSIBLE_ABC, login="cmind")

YT_TOKEN_YAV_SECRET = "sec-01ejbfdk6835yn76tn4rbwar5p#yt.token"


class WeatherCfg(configs.ReferenceBranchedConfig):
    name = "weather"
    responsible = WEATHER_RESPONSIBLE

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        """Testenv configuration"""
        trunk_db = "weather"
        trunk_task_owner = "WEATHER"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="WEATHER_YA_MAKE",
                        build_item="ADMIN",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_path",
                                                output_key="result_path",
                                            ),
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_revision",
                                                output_key="result_revision",
                                            ),
                                        ),
                                    ),
                                ),
                                transform=lambda result_path, result_revision: rm_arc.construct_arc_url(
                                    os.path.join(
                                        result_path or "",
                                        "arcadia",
                                    ),
                                    result_revision,
                                    add_arcadia=False,
                                ),
                                override=True,
                            )
                        ),
                        ctx={
                            "targets": "weather/admin",
                            "arts": "weather/admin/admin",
                            "result_rt": "WEATHER_ADMIN_BINARY",
                            "result_single_file": True,
                            "checkout": True,
                            "ya_yt_token_yav_secret": YT_TOKEN_YAV_SECRET,
                        },
                        out={"WEATHER_ADMIN_BINARY": 40},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="WEATHER_YA_MAKE",
                        build_item="NOWCAST_CPP",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_path",
                                                output_key="result_path",
                                            ),
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_revision",
                                                output_key="result_revision",
                                            ),
                                        ),
                                    ),
                                ),
                                transform=lambda result_path, result_revision: rm_arc.construct_arc_url(
                                    os.path.join(
                                        result_path or "",
                                        "arcadia",
                                    ),
                                    result_revision,
                                    add_arcadia=False,
                                ),
                                override=True,
                            )
                        ),
                        ctx={
                            "targets": "weather/nowcasting/bin",
                            "arts": "weather/nowcasting/bin/nowcasting",
                            "result_rt": "WEATHER_NOWCASTING_BINARY",
                            "result_single_file": True,
                            "checkout": True,
                            "ya_yt_token_yav_secret": YT_TOKEN_YAV_SECRET,
                        },
                        out={"WEATHER_NOWCASTING_BINARY": 40},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="WEATHER_YA_MAKE",
                        build_item="SUPERFACT_FRAME",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_path",
                                                output_key="result_path",
                                            ),
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_revision",
                                                output_key="result_revision",
                                            ),
                                        ),
                                    ),
                                ),
                                transform=lambda result_path, result_revision: rm_arc.construct_arc_url(
                                    os.path.join(
                                        result_path or "",
                                        "arcadia",
                                    ),
                                    result_revision,
                                    add_arcadia=False,
                                ),
                                override=True,
                            )
                        ),
                        ctx={
                            "targets": "weather/superfact/bin/frame",
                            "arts": "weather/superfact/bin/frame/superfact_frame",
                            "result_rt": "WEATHER_SUPERFACT_FRAME_BINARY",
                            "result_single_file": True,
                            "checkout": True,
                            "ya_yt_token_yav_secret": YT_TOKEN_YAV_SECRET,
                        },
                        out={"WEATHER_SUPERFACT_FRAME_BINARY": 40},
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="WEATHER_YA_MAKE",
                        build_item="SUPERFACT_MOVER",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key=sandbox_constants.ARCADIA_URL_KEY,
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_path",
                                                output_key="result_path",
                                            ),
                                            jg_job_data.ParentDataCtx(
                                                input_key="result_revision",
                                                output_key="result_revision",
                                            ),
                                        ),
                                    ),
                                ),
                                transform=lambda result_path, result_revision: rm_arc.construct_arc_url(
                                    os.path.join(
                                        result_path or "",
                                        "arcadia",
                                    ),
                                    result_revision,
                                    add_arcadia=False,
                                ),
                                override=True,
                            )
                        ),
                        ctx={
                            "targets": "weather/superfact/bin/mover",
                            "arts": "weather/superfact/bin/mover/superfact_mover",
                            "result_rt": "WEATHER_SUPERFACT_MOVER_BINARY",
                            "result_single_file": True,
                            "checkout": True,
                            sandbox_constants.DEFINITION_FLAGS_KEY: "-DTENSORFLOW_WITH_CUDA -DCUDA_VERSION=10.1 -DNO_DEBUGINFO",
                            "ya_yt_token_yav_secret": YT_TOKEN_YAV_SECRET,
                        },
                        out={"WEATHER_SUPERFACT_MOVER_BINARY": 40},
                    )
                ]
                for build_item in [
                    "exports",
                    "common",
                    "maps",
                    "imports",
                    "apply",
                    "wrf",
                    "warnings",
                    "exports_cpp",
                    "crawlers_cpp",
                ]:
                    branch_part.append(
                        jg_build.JobGraphElementYaMakeBuildBranched(
                            task_name="WEATHER_YA_MAKE",
                            build_item=build_item,
                            job_params={
                                "frequency": (jg_utils.TestFrequency.LAZY, None),
                            },
                            job_arrows=(
                                jg_arrows.ParentsData(
                                    input_key=sandbox_constants.ARCADIA_URL_KEY,
                                    triggers=(
                                        jg_job_triggers.JobTriggerNewTag(
                                            parent_job_data=(
                                                jg_job_data.ParentDataCtx(
                                                    input_key="result_path",
                                                    output_key="result_path",
                                                ),
                                                jg_job_data.ParentDataCtx(
                                                    input_key="result_revision",
                                                    output_key="result_revision",
                                                ),
                                            ),
                                        ),
                                    ),
                                    transform=lambda result_path, result_revision: rm_arc.construct_arc_url(
                                        os.path.join(
                                            result_path or "",
                                            "arcadia",
                                        ),
                                        result_revision,
                                        add_arcadia=False,
                                    ),
                                    override=True,
                                )
                            ),
                            ctx={
                                "targets": "weather/workers/{}".format(build_item),
                                "arts": "weather/workers/{}/{}".format(build_item, build_item),
                                "result_rt": "WEATHER_QUEUE_{}_BINARY".format(build_item.upper()),
                                "result_single_file": True,
                                "checkout": True,
                                "ya_yt_token_yav_secret": YT_TOKEN_YAV_SECRET,
                            },
                            out={"WEATHER_QUEUE_{}_BINARY".format(build_item.upper()): 40},
                        )
                    )
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_arrows = [
                    jg_job_triggers.JobTriggerBuild(
                        job_name_parameter=build_item,
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                "component_resources",
                                "WEATHER_QUEUE_{}_BINARY".format(build_item.upper()),
                                "WEATHER_QUEUE_{}_BINARY".format(build_item.upper()),
                            )
                        )
                    ) for build_item in [
                        "exports",
                        "common",
                        "maps",
                        "imports",
                        "apply",
                        "exports_cpp",
                        "crawlers_cpp",
                    ]
                ]
                release_part = [
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_ADMIN",
                        job_params={
                            "observed_paths": ["weather/admin", "weather/workers/exports"],
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="admin",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "WEATHER_ADMIN_BINARY",
                                        "WEATHER_ADMIN_BINARY",
                                    )
                                )
                            )
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_ADMIN",
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_WORKERS",
                        job_params={
                            "observed_paths": ["weather/admin", "weather/workers/exports"],
                        },
                        job_arrows=[
                            jg_job_triggers.JobTriggerActionRelease(
                                job_name_parameter="{}__{}".format(
                                    "WEATHER_ADMIN",
                                    rm_const.ReleaseStatus.stable,
                                ),
                            ),
                        ] + release_arrows,
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_WORKERS",
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_WARNINGS",
                        job_params={
                            "observed_paths": ["weather/admin", "weather/workers/exports"],
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerActionRelease(
                                job_name_parameter="{}__{}".format(
                                    "WEATHER_ADMIN",
                                    rm_const.ReleaseStatus.stable,
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="WARNINGS",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "WEATHER_QUEUE_WARNINGS_BINARY",
                                        "WEATHER_QUEUE_WARNINGS_BINARY",
                                    )
                                )
                            )
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_WARNINGS",
                    ),

                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_WRF",
                        job_params={
                            "observed_paths": ["weather/admin", "weather/workers/wrf"],
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerActionRelease(
                                job_name_parameter="{}__{}".format(
                                    "WEATHER_ADMIN",
                                    rm_const.ReleaseStatus.stable,
                                ),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="WRF",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "WEATHER_QUEUE_WRF_BINARY",
                                        "WEATHER_QUEUE_WRF_BINARY",
                                    )
                                )
                            )
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_WRF",
                    ),
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_NOWCASTING",
                        job_params={
                            "observed_paths": ["weather/admin", "weather/nowcasting", "weather/superfact"],
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="NOWCAST_CPP",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "WEATHER_NOWCASTING_BINARY",
                                        "WEATHER_NOWCASTING_BINARY",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="SUPERFACT_FRAME",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "WEATHER_SUPERFACT_FRAME_BINARY",
                                        "WEATHER_SUPERFACT_FRAME_BINARY",
                                    )
                                )
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="SUPERFACT_MOVER",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "WEATHER_SUPERFACT_MOVER_BINARY",
                                        "WEATHER_SUPERFACT_MOVER_BINARY",
                                    )
                                )
                            )
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.stable,
                        release_item="WEATHER_NOWCASTING",
                    )
                ]
                return default_release_part + release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def ignore_prefix(self):
                return super(self.__class__, self).ignore_prefix + [
                    "BUILD",
                    "_TESTING",
                ]

            @property
            def change_frequency(self):
                default = super(self.__class__, self).change_frequency
                default.update({
                    "_{}_NEW_TAG".format(self.name): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return default

    class Releases(configs.ReferenceBranchedConfig.Releases):
        """Releases configuration"""
        resources_info = [
            configs.ReleasedResourceInfo(
                name="WEATHER_ADMIN_BINARY",
                resource_type="WEATHER_ADMIN_BINARY",
                resource_name="WEATHER_ADMIN_BINARY",
                deploy=[(rm_const.ReleaseStatus.stable, "weather-prod-admin-yp")],
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_SCHEDULER_BINARY",
                resource_type="WEATHER_QUEUE_SCHEDULER_BINARY",
                resource_name="WEATHER_QUEUE_SCHEDULER_BINARY",
                deploy=[(rm_const.ReleaseStatus.stable, "weather-prod-workers-8")],
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_EXPORTS_BINARY",
                resource_type="WEATHER_QUEUE_EXPORTS_BINARY",
                resource_name="WEATHER_QUEUE_EXPORTS_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_IMPORTS_BINARY",
                resource_type="WEATHER_QUEUE_IMPORTS_BINARY",
                resource_name="WEATHER_QUEUE_IMPORTS_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_COMMON_BINARY",
                resource_type="WEATHER_QUEUE_COMMON_BINARY",
                resource_name="WEATHER_QUEUE_COMMON_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_APPLY_BINARY",
                resource_type="WEATHER_QUEUE_APPLY_BINARY",
                resource_name="WEATHER_QUEUE_APPLY_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_MAPS_BINARY",
                resource_type="WEATHER_QUEUE_MAPS_BINARY",
                resource_name="WEATHER_QUEUE_MAPS_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_WARNINGS_BINARY",
                resource_type="WEATHER_QUEUE_WARNINGS_BINARY",
                resource_name="WEATHER_QUEUE_WARNINGS_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_WRF_BINARY",
                resource_type="WEATHER_QUEUE_WRF_BINARY",
                resource_name="WEATHER_QUEUE_WRF_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_NOWCASTING_BINARY",
                resource_type="WEATHER_NOWCASTING_BINARY",
                resource_name="WEATHER_NOWCASTING_BINARY",
                deploy=[(rm_const.ReleaseStatus.stable, "weather-prod-workers-nowcast")],
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_NOWCASTING_GPU_BINARY",
                resource_type="WEATHER_NOWCASTING_GPU_BINARY",
                resource_name="WEATHER_NOWCASTING_GPU_BINARY",
                deploy=[(rm_const.ReleaseStatus.stable, "weather-prod-workers-mix")],
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_SUPERFACT_FRAME_BINARY",
                resource_type="WEATHER_SUPERFACT_FRAME_BINARY",
                resource_name="WEATHER_SUPERFACT_FRAME_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_SUPERFACT_MOVER_BINARY",
                resource_type="WEATHER_SUPERFACT_MOVER_BINARY",
                resource_name="WEATHER_SUPERFACT_MOVER_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_TILESERVER_BINARY",
                resource_type="WEATHER_TILESERVER_BINARY",
                resource_name="WEATHER_TILESERVER_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_EXPORTS_CPP_BINARY",
                resource_type="WEATHER_QUEUE_EXPORTS_CPP_BINARY",
                resource_name="WEATHER_QUEUE_EXPORTS_CPP_BINARY",
            ),
            configs.ReleasedResourceInfo(
                name="WEATHER_QUEUE_CRAWLERS_CPP_BINARY",
                resource_type="WEATHER_QUEUE_CRAWLERS_CPP_BINARY",
                resource_name="WEATHER_QUEUE_CRAWLERS_CPP_BINARY",
            ),
        ]
        release_followers_permanent = []
        allow_robots_to_release_stable = True
        wait_for_deploy_time_sec = 120

    class Notify(configs.ReferenceBranchedConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type=event_type,
                chat_name="weather_releases",
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="TEXT_EXACTLY_IS",
                            value="SUCCESS",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="TEXT_EXACTLY_IS",
                            value="FAILURE",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="TEXT_EXACTLY_IS",
                            value="EXCEPTION",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="TEXT_EXACTLY_IS",
                            value="STOPPED",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="TEXT_EXACTLY_IS",
                            value="TIMEOUT",
                        ),
                    ],
                    join_strategy="OR",
                ),
            ) for event_type in (
                "NewBranch",
                "TestenvDbClone",
                "TicketHistory",
                "NewWikiPage",
                "MergeCommit",
                "NewTag",
                "ChangelogCreated",
            )
        ] + [
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name="weather_releases",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="weather_releases",
                message_template_file='notifications/release_created_oldschool.html',
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            """Telegram notifications configuration"""
            chats = ["weather_releases"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            """Startrek notifications configuration"""
            assignee = WEATHER_RESPONSIBLE
            queue = "WEATHERRELEASES"
            dev_queue = "WEATHER"
            summary_template = u"Приемка погодного релиза {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = []
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        """Changelog configuration"""
        wiki_page = "weather/releases/"
        dirs = [
            "arcadia/weather/admin/",
            "arcadia/weather/workers/",
            "arcadia/weather/db/",
            "arcadia/weather/settings/",
            "arcadia/weather/libs/",
            "arcadia/weather/meteo/flow/scheduler/",
            "arcadia/weather/nowcasting/",
            "arcadia/weather/superfact/",
        ]
        markers = [
            (4, re.compile(r"((\bWEATHER-\d+|\bMETEO-\d+)(?!.*\[ignore_me\]))")),
        ]
