# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


RESOURCES = [
    "HORIZON_AGENT_CONFIG_WEATHER",
    "APP_HOST_STABLE_BRANCH_WEATHER",
]

#                                               weather         duty
WEATHER_RESPONSIBLE_ABC = configs.Abc(component_id=105, schedule_slug="main_prod_duty")
WEATHER_RESPONSIBLE = configs.Responsible(abc=WEATHER_RESPONSIBLE_ABC, login="cmind")


class WeatherGraphsCfg(configs.ReferenceBranchedConfig):
    name = "weather_graphs"
    responsible = WEATHER_RESPONSIBLE

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "WEATHER"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_HORIZON_AGENT_CONFIG",
                build_ctx={"vertical": "WEATHER"},
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name=resource.lower(),
                    data=ri.SandboxResourceData(resource, ttl=90),
                    deploy_infos=[ri.single_nanny_service("weather-prod-app-host-man")],
                ) for resource in RESOURCES
            ]
        allow_robots_to_release_stable = True

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/weather"
        tag_name = "apphost/conf/weather"

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = WEATHER_RESPONSIBLE
            queue = "WEATHERRELEASES"
            summary_template = u"Приемка графов WEATHER {}"
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 5

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "weather/releases/graphs/"
        ya_make_targets = [
            "arcadia/apphost/conf/verticals/WEATHER",
        ]
