# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
from sandbox.projects.release_machine.components.configs.report import SearchIntergationTestBundle
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications


class WebGraphMappingCfg(configs.ReferenceBranchedConfig):
    component_group = "reference_component_metricsed"
    name = "web_graph_mapping"
    responsible = "avitella"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "REPORT_CORE"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="BUILD_HORIZON_AGENT_CONFIG",
                        build_item="HORIZON_AGENT_CONFIG",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                jg_job_data.ParentDataCtx(
                                    input_key="stable_branch",
                                    output_key="result_path",
                                    transform=lambda x, params: x.replace("arcadia:/arc/", "").replace("/", "_"),
                                ),
                            )
                        ),
                        out={
                            "HORIZON_AGENT_CONFIG_WEB": 90,
                            "APP_HOST_STABLE_BRANCH_WEB": 90,
                        },
                        ctx={
                            "vertical": "WEB",
                        }
                    ),
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="beta",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="HORIZON_AGENT_CONFIG",
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "horizon_agent_config",
                                        "HORIZON_AGENT_CONFIG_WEB",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "app_host_stable_branch",
                                        "APP_HOST_STABLE_BRANCH_WEB",
                                    ),
                                )
                            )
                        )
                    )
                ]
                WEB_GRAPH_MAPPINGS_SLA_PROJECT = "aa8286386850f0df016874cc48882d44"  # Metrics SLA-project "SLA Release Machine", more info at https://metrics.yandex-team.ru/admin/sla
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="checked_beta",
                                        output_key="new_beta_url",
                                    ),
                                )
                            ),
                        ),
                        ctx={
                            "sample_beta": "hamster",
                            "scraper_over_yt_pool": "mapping_web_priemka",
                            "sla_project": WEB_GRAPH_MAPPINGS_SLA_PROJECT,
                        }
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestXMLSearch(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="beta_url",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "https://{}.ru".format(x),
                                    ),
                                )
                            ),
                        ),
                        ctx={"search_subtypes": "web"},
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementE2ETest(
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="hermionee2e_base_url",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "https://{}.ru".format(x),
                                    )
                                )
                            )
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestTdiAndRearr(
                        job_params={
                            "ctx": {
                                "launch_videoserp_RA": False,
                                "scraper_over_yt_pool": "mapping_web_priemka",
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="checked_beta",
                                        output_key="new_beta_url",
                                    ),
                                )
                            ),
                        ),
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="SITESEARCH_INTEGRATION_TEST",
                        job_params={
                            "job_name_parameter": "SITESEARCH_INTEGRATION_TEST",
                            "frequency": (jg_utils.TestFrequency.LAZY, None),
                            "apiargs": {
                                "kill_timeout": 3 * 3600,
                                "requirements": {
                                    "platform": "linux_ubuntu_16.04_xenial",
                                },
                            },
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                job_name_parameter="beta",
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput(
                                        input_key="serp_host",
                                        output_key="new_beta_url",
                                        transform=lambda x, params: "{}.ru".format(x),
                                    )
                                )
                            )
                        ),
                        ctx={
                            "description": (
                                "SitesearchTests for mapping release. "
                                "Responsible from fronend sitesearch: https://abc.yandex-team.ru/services/wmcon/duty/"
                            ),
                            "git_reference": "dev"
                        },
                    )
                )
                for t in SearchIntergationTestBundle.get_bundle(soy_pool="mapping_web_priemka"):
                    branch_part.append(t)

                branch_part.append(
                    jg_test.JobGraphElementMetaTestBranched(
                        task_name="KOSHER_YA_MAKE",
                        job_params={
                            "job_name_parameter": "ARCADIA_GRAPHS_WEB",
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 120 * (1024 ** 3),  # 120 Gb
                                },
                                "kill_timeout": 1 * 60 * 60,  # 1 hour
                            }
                        },
                        ctx={
                            "targets": "apphost/conf/tests",
                            "test": True,
                            "disable_test_timeout": True,
                            "ya_timeout": 1 * 60 * 60,
                            "test_filters": "*WEB*",
                        },
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranchedByMarker(
                        job_arrows=(
                            jg_job_triggers.JobTriggerLaunchMetrics(
                                job_name_parameter="web",
                            ),
                            jg_job_triggers.JobTriggerE2ETest(),
                            jg_job_triggers.JobTriggerTestTdiAndRearr(),
                            jg_job_triggers.JobTriggerTestXMLSearch(),
                            jg_job_triggers.JobTriggerMetaTest(
                                job_name_parameter="SEARCH_INTEGRATION_TEST",
                            ),
                            jg_job_triggers.JobTriggerMetaTest(
                                job_name_parameter="SEARCH_INTEGRATION_TEST_SOY_HTTP",
                            ),
                            jg_job_triggers.JobTriggerMetaTest(
                                job_name_parameter="SEARCH_INTEGRATION_TEST_STYLE",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SITESEARCH_INTEGRATION_TEST",
                            ),
                        )
                    )
                )
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = []
                build_trigger = jg_job_triggers.JobTriggerBuild(
                    job_name_parameter="HORIZON_AGENT_CONFIG",
                    parent_job_data=(
                        jg_job_data.ParentDataDict(
                            "component_resources",
                            "app_host_stable_branch",
                            "APP_HOST_STABLE_BRANCH_WEB",
                        ),
                    )
                )
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=build_trigger,
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                        )
                    )
                release_part.extend([
                    jg_release.JobGraphElementScheduleRelease(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny_push.name,
                                "flows": ["deploy"],
                                "warden_component_name": "web_graph_mappings",
                                "warden_parent_component_name": "web",
                            }
                        },
                        job_arrows=build_trigger,
                    ),
                    jg_release.JobGraphElementActionScheduleBranched(
                        rm_const.ReleaseStatus.stable,
                        release_item="MORTY"
                    ),
                ])
                return default_release_part + release_part

    class ReleaseViewer(configs.ReferenceConfig.ReleaseViewer):
        kpi_alert = 3
        kpi_alert_skip_weekends = True
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="app_host_stable_branch",
                    data=ri.SandboxResourceData("APP_HOST_STABLE_BRANCH_WEB"),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("production_app_host_{}_web_yp".format(i))
                                for i in rm_const.MAIN_LOCATIONS
                            ]
                        ),
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService("hamster_app_host_{}_web_yp".format(i), tags=["hamster"])
                                for i in rm_const.MAIN_LOCATIONS
                            ],
                            stage=rm_const.ReleaseStatus.testing,
                        ),
                    ]
                ),
                ri.DynamicReleasableItem(
                    name="scheduled_bundle",
                    data=ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    deploy_infos=[ri.NannyDeployInfo()],
                )
            ]
        release_followers_permanent = [
            "alex-ersh",
            "elshiko",
            "feldsherov",
        ]
        allow_robots_to_release_stable = True
        allow_old_releases = True

    class Notify(configs.ReferenceBranchedConfig.Notify):

        notifications = [
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_SUCCESS_AND_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.STARTREK_TICKET_CREATED_CONDITIONS,
                    join_strategy="OR",
                ),
                message_template_file="notifications/ticket_created.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseDeployed",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_deployed_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name="report_from_rm_const",
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
        ]

        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["report"]
            invite_link = "https://t.me/joinchat/CaUODkYSN2MyE5jE9xgJzg"
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "elshiko"
            queue = "SEAREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка Web Mapping {}"
            components = u"web_report_mapping"
            workflow = {}
            followers = []
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 4

            @property
            def banned_people(self):
                return super(self.__class__, self).banned_people | {"zhshishkin"}

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "serp/report/releases/web-mapping/"
        observed_paths = [
            "arcadia/apphost/conf/verticals/WEB",
            "arcadia/apphost/conf/backends",
        ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "apphost/conf/web"
        tag_name = "apphost/conf/web"
        allow_autobranches = True

    class Yappy(yappy_cfg.YappyBaseCfg):
        betas = {
            "beta": yappy_cfg.YappyTemplateCfg(
                template_name="graph-mapping-web",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="graph-mapping-web",
                        resources=[
                            yappy_cfg.YappyParametrizedResource("app_host_stable_branch", "stable_branch"),
                        ],
                        parent_service="hamster_app_host_sas_web_yp",
                    ),
                ],
            ),
        }
