# -*- coding: utf-8 -*-

import os
import sandbox.projects.release_machine.components.config_core.statistics_page as statistics_page
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import build as build_cubes
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.config_core.jg.preset.upper_search import upper_search_presets
from sandbox.projects.release_machine.components.config_core.jg.cube import base as jg_cube
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.components.config_core import notifications as rm_notifications
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.upper_search.base import TestLogs
from sandbox.projects.release_machine.components.configs import upper_search

# ya make tasks
BINARY_PATH = "web/src_setup/daemons/vertical/WEB/src_setup"
CONFIG_PATH = "web/src_setup/conf/vertical/WEB/static_config"
INSTANCECTL_CONFIG_PATH = "web/src_setup/deploy/vertical/WEB/instancectl.conf"
EVENT_LOG_DUMP_PATH = "web/src_setup/tools/event_log_dump"

# global variables
CHAT_NAME = "src_setup_releases"


class WebSrcSetupCfg(upper_search.UpperSearchReferenceCIConfig):
    name = "web_src_setup"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="web_src_setup"),
        login="elshiko"
    )
    robot = "robot-src-setup-web"

    class JG(upper_search_presets.UpperSearchSingleBuildYaMakeJGCfg):
        # JG params and stages init
        add_beta_generator = "web"

        # configuring auto-deploy
        release_manually = False

        # morty configuration
        morty_config = {
            "nanny_dashboard_flow": "deploy",
            "warden_component_name": "src_setup",
            "warden_parent_component_name": "web",
        }

        # iceflame configuration
        iceflame_nanny_service = "hamster_src_setup_sas_web_yp"
        iceflame_config_name = "src_setup.conf"

        # sanitizer tests
        sanitizer_tests_targets = ["web/src_setup/tests/pseudo_src_setup/WEB"]
        sanitizer_tests_sanitizers = [
            "address",
            None,
            "thread",
        ]

        # extra release flow params
        release_flow_params = {
            "title": "Release Src Setup WEB",
            "auto": {
                "conditions": [
                    {
                        "schedule": {
                            "time": "00:00 - 01:00 MSK",
                            "days": "TUE,THU",
                        },
                    },
                    {
                        "schedule": {
                            "time": "19:00 - 20:00 MSK",
                            "days": "SUN",
                        },
                    },
                ]
            },
        }

        def _get_beta_tests_bundle(self, graph):
            beta_cube = graph.get("generate_beta__web_src_setup__web")
            return upper_search.web.SearchIntegrationTestsBundle.get_bundle(beta_cube, "src_setup_web_priemka") + [TestLogs(beta_cube)]

        def _get_build_cube(self, graph):
            targets = []
            artifacts = []
            source_artifacts = []
            resource_types = []

            for item in self.suitable_releasable_items:
                targets.append(item.build_data.target)
                if item.build_data.is_source:
                    source_artifacts.append(item.build_data.artifact)
                else:
                    artifacts.append(item.build_data.artifact)
                resource_types.append(item.data.resource_type)

            return build_cubes.YaMakeBuildCubeBase(
                name=self.build_cube_name,
                task=self.build_task,
                targets=targets,
                artifacts=artifacts,
                source_artifacts=source_artifacts,
                resource_types=resource_types,
                input=jg_cube.CubeInput(
                    result_attrs={
                        "major_release_num": rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM,
                        "minor_release_num": rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM,
                    },
                    thinlto=True,
                ),
                needs=[
                    graph.get(dummy_cubes.RMMainGraphEntry.NAME),
                ],
            )

    class CI(upper_search.UpperSearchReferenceCIConfig.CI):
        a_yaml_dir = BINARY_PATH
        secret = "sec-01g02dcjabbha085e83qvcxggm"
        sb_owner_group = "SEARCH-RELEASERS"

        ya_make_abs_paths_glob = [
            os.path.join(BINARY_PATH, "**"),
            os.path.join(CONFIG_PATH, "**"),
        ]

    class Releases(upper_search.UpperSearchReferenceCIConfig.Releases):

        allow_old_releases = True
        allow_robots_to_release_stable = True

        # turning on independent stages https://docs.yandex-team.ru/ci/release#independent-stages
        main_release_flow_independent_stages = True

        @property
        def releasable_items(self):
            def release_it(name, resource_type, dst_path, target, artifact_name, deploy_infos):
                return ri.ReleasableItem(
                    name,
                    data=ri.SandboxResourceData(resource_type, dst_path=dst_path),
                    build_data=ri.BuildData(
                        target=target,
                        artifact=os.path.join(target, artifact_name),
                    ),
                    deploy_infos=deploy_infos,
                )

            hamster_services = [
                "hamster_src_setup_sas_web_yp",
                "hamster_src_setup_man_web_yp",
                "hamster_src_setup_vla_web_yp",
            ]

            prestable_services = [
                "prestable_src_setup_sas_web_yp",
            ]

            production_services = [
                "production_src_setup_man_web_yp",
                "production_src_setup_sas_web_yp",
                "production_src_setup_vla_web_yp",
            ]

            release_deploy_infos = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService(service, tags=["hamster"]) for service in hamster_services
                    ] + [
                        ri.DeployService(service, tags=["prestable"]) for service in prestable_services
                    ] + [
                        ri.DeployService(service, tags=["production"]) for service in production_services
                    ]
                ),
            ]

            return [
                release_it(
                    name="web_src_setup_binary",
                    resource_type="WEB_SRC_SETUP_BINARY",
                    dst_path="src_setup",
                    target=BINARY_PATH,
                    artifact_name="src_setup",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="web_src_setup_config",
                    resource_type="WEB_SRC_SETUP_CONFIG",
                    dst_path="config.json",
                    target=CONFIG_PATH,
                    artifact_name="config.json",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="web_src_setup_instancectl_config",
                    resource_type="WEB_SRC_SETUP_INSTANCECTL_CONFIG",
                    dst_path="instancectl.conf",
                    target=INSTANCECTL_CONFIG_PATH,
                    artifact_name="instancectl.conf",
                    deploy_infos=release_deploy_infos,
                ),
                release_it(
                    name="web_src_setup_event_log_dump",
                    resource_type="SRC_SETUP_EVENT_LOG_DUMP",
                    dst_path="event_log_dump",
                    target=EVENT_LOG_DUMP_PATH,
                    artifact_name="event_log_dump",
                    deploy_infos=release_deploy_infos,
                ),
                ri.DynamicReleasableItem(
                    name="scheduled_bundle",
                    data=ri.SandboxResourceData("SCHEDULED_RM_RELEASE_DATA"),
                    deploy_infos=[ri.NannyDeployInfo()],
                ),
            ]

    class MergesCfg(upper_search.UpperSearchReferenceCIConfig.MergesCfg):
        permissions = configs.MergePermissions(
            permission_type=rm_const.PermissionType.ALLOWED,
            people_groups=configs.PeopleGroups(
                staff_groups=None,
                # https://abc.yandex-team.ru/services/upper/
                abc_services=[configs.Abc(component_id=1609, role_id=None)],
                logins=None,
            ),
        )

        def not_granted_message(self, author, responsible):
            return """
                Merger {} is not allowed to merge into {}.
                Please, visit web_src_setup releases chat: https://t.me/joinchat/BwkfgA6-Mif5lJ7PnNCkpA
                or contact current release engineer on duty: https://abc.yandex-team.ru/services/upper/duty/
            """.format(
                author, self.name,
            )

    class Yappy(upper_search.UpperSearchReferenceCIConfig.Yappy):
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="src-setup-web",
                new_yappy=True,
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="src-setup-web",
                        resources=[
                            yappy_cfg.YappyParametrizedResource(
                                local_path="instancectl.conf",
                                param_name="web_src_setup_instancectl_config",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="src_setup",
                                param_name="web_src_setup_binary",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="event_log_dump",
                                param_name="web_src_setup_event_log_dump",
                            ),
                            yappy_cfg.YappyParametrizedResource(
                                local_path="config.json",
                                param_name="web_src_setup_config",
                            ),
                        ],
                        parent_service="hamster_src_setup_sas_web_yp",
                    ),
                ],
            ),
        }

    class Notify(upper_search.UpperSearchReferenceCIConfig.Notify):
        """Notifications configuration"""

        notifications = [
            rm_notifications.Notification(
                event_type="NewBranch",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="NewTag",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="BuildTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="KpiAlert",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="NewBetaGeneration",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=rm_notifications.TASK_PROBLEM_CONDITIONS,
                    join_strategy="OR",
                ),
            ),
            rm_notifications.Notification(
                event_type="TicketHistory",
                chat_name=CHAT_NAME,
                message_template_file="notifications/web_src_setup/ticket_history.html",
                pin=True,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="general_data.referrer",
                            operator="TEXT_EXACTLY_IS",
                            value="tasklet:create_startrek_ticket",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="ci_job_instance_id.job_id",
                            operator="TEXT_EXACTLY_IS",
                            value="create_startrek_ticket",
                        ),
                        rm_notifications.NotificationConditionItem(
                            field="ci_job_context.version_info.minor",
                            operator="TEXT_EXACTLY_IS",
                            value="",
                        ),
                    ],
                    join_strategy="AND",
                ),
            ),
            rm_notifications.Notification(
                event_type="ReleaseFailed",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="MergeCommit",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
            ),
            rm_notifications.Notification(
                event_type="ReleaseCreated",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.CONDITION_ALWAYS,
                message_template_file="notifications/release_created_oldschool.html",
            ),
            rm_notifications.Notification(
                event_type="MetaTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="AND",
                ),
                message_template_file="notifications/src_setup/meta_test.html",
            ),
            rm_notifications.Notification(
                event_type="GenericTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="AND",
                ),
                message_template_file="notifications/src_setup/generic_test.html",
            ),
            rm_notifications.Notification(
                event_type="AcceptanceTest",
                chat_name=CHAT_NAME,
                conditions=rm_notifications.NotificationCondition(
                    conditions=[
                        rm_notifications.NotificationConditionItem(
                            field="task_data.status",
                            operator="IN",
                            value=",".join(rm_notifications.TASK_PROBLEM_STATUSES),
                        ),
                    ],
                    join_strategy="OR",
                ),
            ),
        ]

        class Telegram(upper_search.UpperSearchReferenceCIConfig.Notify.Telegram):
            chats = [CHAT_NAME]
            config = configs.RmTelegramNotifyConfig(chats=chats)
            invite_link = u"https://t.me/joinchat/BwkfgA6-Mif5lJ7PnNCkpA"

        class Startrek(upper_search.UpperSearchReferenceCIConfig.Notify.Startrek):
            assignee = "elshiko"
            queue = "WEBSRCSETUPREL"
            dev_queue = "SEARCH"
            summary_template = u"Приемка Web Src Setup {}"
            workflow = {
                "open": "autoTesting",
                "fixProblems": "accepting",
                "production": "close",
                "closed": "reopen",
                "qualityOK": "deploying",
                "accepting": "qualityOK",
                "autoTesting": "autoTestsOK",
                "autoTestsOK": "accepting",
                "deploying": "production",
            }
            followers = [
                "elshiko",
            ]
            add_commiters_as_followers = True
            use_task_author_as_assignee = False
            deadline = 7

            @property
            def banned_people(self):
                return super(self.__class__, self).banned_people | {"zhshishkin"}

    class ChangelogCfg(upper_search.UpperSearchReferenceCIConfig.ChangelogCfg):
        observed_paths = [
            "arcadia/web/src_setup"
        ]

        use_previous_branch_as_baseline = True

    class MetricsCfg(upper_search.UpperSearchReferenceCIConfig.MetricsCfg):
        limit_s = None

    class ReleaseViewer(upper_search.UpperSearchReferenceCIConfig.ReleaseViewer):
        """Release viewer configuration"""
        kpi_alert = 7
        statistics_page_charts = statistics_page.DEFAULT + [statistics_page.PredefinedCharts.TIMESPECTRE_METRICS]
