# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class WolandCfg(configs.ReferenceTrunkConfig):
    component_group = 'component_info_general'
    name = "woland"
    responsible = "gluk47"

    class Releases(configs.ReferenceTrunkConfig.Releases):
        resources_info = [
            configs.ReleasedResourceInfo(
                name="woland",
                resource_type="WOLAND_EXECUTABLE",
                resource_name="woland_executable_resource_id",
            ),
            configs.ReleasedResourceInfo(
                name="panels",
                resource_type="WOLAND_PANELS",
                resource_name="woland_panels_resource_id",
            ),
        ]

        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "smishin",
            "gluk47",
        ]

    class Testenv(configs.ReferenceTrunkConfig.Testenv):
        trunk_db = "woland"
        trunk_task_owner = "SEARCH-RELEASERS"

        class JobGraph(configs.ReferenceTrunkConfig.Testenv.JobGraph):
            @property
            def _trunk_part(self):
                default_trunk_part = super(self.__class__, self)._trunk_part
                trunk_part = [
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_SEARCH",
                        build_item="BINARY",
                        job_params={
                            "observed_paths": ["search/tools/woland"],
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        ctx={
                            "build_bundle": False,
                            "build_type": "release",
                            "build_woland": True,
                        },
                        out={
                            "WOLAND_EXECUTABLE": 30,
                        }
                    ),
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="BUILD_WOLAND_PANELS_BUNDLE",
                        build_item="PANELS",
                        job_params={
                            "observed_paths": [
                                "search/tools/woland/panels",
                                "apphost/conf/verticals",
                                "sandbox/projects/woland/BuildWolandPanelsBundle/",
                            ],
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        out={
                            "WOLAND_PANELS": 30,
                        }
                    ),
                    jg_build.JobGraphElementBuildTrunk(
                        task_name="YA_MAKE",
                        job_params={
                            "observed_paths": ["search/tools/woland"],
                            "job_type": rm_const.JobTypes.TEST,
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                        },
                        build_item="PYTEST",
                        ctx={
                            "build_type": "release",
                            "use_dev_version": False,
                            "targets": "search/tools/woland/tests",
                            "test": True,
                        },
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="WOLAND_ALERTING",
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "job_name_parameter": "ALERTS",
                            "job_type": rm_const.JobTypes.RELEASE,
                            "observed_paths": [
                                "search/tools/woland/lib",
                                "search/tools/woland/panels",
                                "apphost/conf/verticals",
                            ],
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="woland_binary_id",
                                        resource_name="WOLAND_EXECUTABLE",
                                    ),
                                ),
                                job_name_parameter="BINARY",
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="woland_panels_id",
                                        resource_name="WOLAND_PANELS",
                                    ),
                                ),
                                job_name_parameter="PANELS",
                            ),
                        ),
                    )
                ]
                return default_trunk_part + trunk_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBase(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "observed_paths": ["arcadia/search/tools/woland", "arcadia/apphost/conf/verticals"],
                            "ignored_paths": ["arcadia/search/tools/woland/tests"],
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "woland_executable_resource_id",
                                        "WOLAND_EXECUTABLE",
                                    ),
                                ),
                                job_name_parameter="BINARY",
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "woland_panels_resource_id",
                                        "WOLAND_PANELS",
                                    ),
                                ),
                                job_name_parameter="PANELS",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="PYTEST",
                            )
                        )
                    ),
                    jg_release.JobGraphElementActionSingleRelease(
                        job_name_parameter=rm_const.ReleaseStatus.stable,
                        job_params={
                            "should_add_to_db": jg_utils.should_add_to_db_trunk,
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 30),
                        },
                    )
                ]
                return default_release_part + release_part
