# -- coding: utf-8 --

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.presets as jg_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class WorkplaceCfg(configs.ReferenceBranchedConfig):
    name = "workplace"
    responsible = "lebedev-aa"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_db = "workplace"
        trunk_task_owner = "MARTY"
        assignee = "lebedev-aa"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            _preset = jg_presets.SingleBuildPreset(
                build_task_name="BUILD_WORKPLACE2",
                build_ctx={"vertical": "TOOLS"},
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable)],
            )

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="workplace_res_id",
                    data=ri.SandboxResourceData("WORKPLACE_ENTRYPOINT", ttl=30),
                    deploy_infos=[ri.single_nanny_service("workplace-zephyr")],
                ),
            ]
        allow_robots_to_release_stable = True

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "lebedev-aa"
            queue = "WPREL"
            summary_template = u"Приёмка  Workplace {}"

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        observed_paths = ["arcadia/search/mon/workplace"]
        wiki_page = "jandekspoisk/sepe/dezhurnajasmena/workplace/releases"
