# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.release_machine.components.job_graph.presets import ci_presets
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class XmlCounterCfg(configs.ReferenceCIConfig):
    name = 'xml_counter'
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="xmlsearchruntime"),
        login="i024"
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "search/xml/counter"
        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"
        grant_config_update_permissions_to_release_machine_robot = False

        class JobGraph(configs.ReferenceCIConfig.CI.JobGraph):
            _preset = ci_presets.SingleBuildCiPreset(
                build_task_name="KOSHER_YA_MAKE",
                build_ctx={
                    "targets": "search/xml/counter",
                    "arts": "search/xml/counter/counter",
                    "result_rt": "XML_COUNTER",
                },
                deploy_system=rm_const.DeploySystem.nanny.name,
                stages=[
                    jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.stable, jg_utils.Lazy()),
                ],
            )

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="xml_counter",
                    data=ri.SandboxResourceData("XML_COUNTER"),
                    deploy_infos=[
                        ri.single_nanny_service("xml_counter_man"),
                        ri.single_nanny_service("xml_counter_vla"),
                        ri.single_nanny_service("xml_counter_sas"),
                    ],
                )
            ]

        allow_robots_to_release_stable = True
        release_followers_permanent = [
            "i024",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        use_startrek = False
