# -*- coding: utf-8 -*-
"""
Release machine for Xurma Dsp graph
"""
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.xurma.rm as xurma_rm


class XurmaDspCfg(configs.ReferenceBranchedConfig):
    name = "xurma_dsp"
    responsible = xurma_rm.RESPONSIBLE

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/quality/antifraud/xurma",
        ]
        wiki_page = "JandeksPoisk/Antirobots/Xurma/releases/releases-dsp/"
        wiki_page_owner = xurma_rm.WIKI_PAGE_OWNER

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="xurma",
                    data=ri.SandboxResourceData("XURMA_DSP_DATA"),
                    deploy_infos=[
                        xurma_rm.ya_deploy_stage("xurma-dsp-prod"),
                        xurma_rm.ya_deploy_stage("xurma-dsp-preprod", stage=rm_const.ReleaseStatus.prestable),
                    ],
                )
            ]
        allow_robots_to_release_stable = True

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = xurma_rm.TRUNK_TASK_OWNER
        testenv_db_owners = xurma_rm.TESTENV_DB_OWNERS

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _prerelease(self):
                """
                    Prerelease part of job graph for Testenv with arrows and dependencies
                    :return: list with jobs
                """
                return [
                    jg_prerelease.JobGraphElementNewBranch(),
                    jg_prerelease.JobGraphElementPreliminaryChangelogBranched(),
                    xurma_rm.JobGraphElementChangelogProcessor(ctx={
                        "graph_name": "dsp",
                    }),
                    jg_prerelease.JobGraphElementCloneDb(),
                    jg_prerelease.JobGraphElementStartrekBase(job_arrows=(
                        jg_arrows.JobTrigger(
                            "CHANGELOG_PROCESSOR",
                            jg_data.ParentDataResource("changelog", "RELEASE_MACHINE_CHANGELOG"),
                        ),
                    )),
                    jg_prerelease.JobGraphElementWikiBase(job_arrows=(
                        jg_arrows.JobTrigger(
                            "CHANGELOG_PROCESSOR",
                            jg_data.ParentDataResource("changelog", "RELEASE_MACHINE_CHANGELOG"),
                        ),
                        jg_triggers.JobTriggerStartrek(),
                    )),
                    jg_prerelease.JobGraphElementActionPreReleaseStartrekWiki(),
                ]

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="XURMA_BUILD_DSP",
                        out={
                            "XURMA_DSP_DATA": 30,
                            "XURMA_DEBUG": 30,
                        },
                        ctx={
                            "use_aapi_fuse": True,
                            "packages": "quality/antifraud/xurma/deploy/xurma/graphs/dsp.json;quality/antifraud/xurma/deploy/xurma/debug.json",
                            "resource_type": "XURMA_DSP_DATA;XURMA_DEBUG",
                        },
                    )
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                # stable
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=rm_const.ReleaseStatus.stable,
                    job_arrows=[
                        jg_triggers.JobTriggerBuild(
                            parent_job_data=[
                                jg_data.ParentDataDict(
                                    input_key="component_resources",
                                    dict_key="xurma",
                                    resource_name="XURMA_DSP_DATA",
                                ),
                            ],
                        ),
                    ]
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=rm_const.ReleaseStatus.stable,
                ))
                # prestable
                release_part.append(jg_release.JobGraphElementReleaseBranched(
                    release_to=rm_const.ReleaseStatus.prestable,
                    job_arrows=[
                        jg_triggers.JobTriggerBuild(
                            parent_job_data=[
                                jg_data.ParentDataDict(
                                    input_key="component_resources",
                                    dict_key="xurma",
                                    resource_name="XURMA_DSP_DATA",
                                ),
                            ],
                        ),
                    ]
                ))
                release_part.append(xurma_rm.JobGraphElementAgreementMaker(
                    job_name_parameter="prestable",
                    ctx={
                        "text": u"Согласование на приемку релиза",
                        "approvers": ["gles,evdokimenko"],
                    }
                ))
                release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                    release_to=rm_const.ReleaseStatus.prestable,
                    job_arrows=(jg_arrows.JobTrigger("AGREEMENT_MAKER"))
                ))
                return release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            @property
            def ignore_prefix(self):
                return super(self.__class__, self).ignore_prefix + [
                    "_CHANGELOG_PROCESSOR",
                ]

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "xurma/graphs/dsp"
        tag_name = "xurma/graphs/dsp"

    class Notify(configs.ReferenceBranchedConfig.Notify):

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            queue = xurma_rm.STARTREK_QUEUE
            assignee = xurma_rm.STARTREK_ASSIGNEE
            ticket_type = "Release"
            summary_template = u"Xurma Dsp graph {}"
            add_commiters_as_followers = False
            followers = [assignee, "gles", "evdokimenko"]
            workflow = xurma_rm.STARTREK_WORKFLOW
