# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.config_core import release_block
from sandbox.projects.common.constants import constants as common_const

import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils

PROJECT_PATHS = [
    "arcadia/quality/functionality/rtx/trends",
    "arcadia/quality/trailer/suggest/services/searchlib/server/surface_processor",
]


class YaStrokaTaggedCfg(cfg.ReferenceTaggedConfig):
    name = "ya_stroka"
    # https://abc-back.yandex-team.ru/api/v4/services/members/?service__slug=RTX&role_id=1097
    responsible = cfg.Responsible(abc=cfg.Abc(role_id=1097, component_id=2470), login="evgen")

    class Releases(cfg.ReferenceTaggedConfig.Releases):
        @property
        def resources_info(self):
            return [
                cfg.ReleasedResourceInfo(
                    name=self.name,
                    resource_type="YA_STROKA_BINARY",
                    resource_name="{}_res_id".format(self.name),
                    deploy=[
                        cfg.DeployServicesInfo(
                            level=rm_const.ReleaseStatus.stable, services=["yastroka-prod-yp"]
                        ),
                        cfg.DeployServicesInfo(
                            level=rm_const.ReleaseStatus.testing, services=["yastroka-test-yp"]
                        ),
                    ],
                )
            ]

        allow_old_releases = True
        allow_robots_to_release_stable = True
        release_followers_permanent = ['evgen']
        wait_for_deploy_time_sec = 30 * 60  # 30 min
        block_on_test_results = [release_block.NEVER_BLOCK]

    class Testenv(cfg.ReferenceTaggedConfig.Testenv):
        trunk_task_owner = "YASTROKA"

        # Read our documentation for better understanding https://wiki.yandex-team.ru/ReleaseMachine/JobGraph/
        class JobGraph(cfg.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                tag_part = super(self.__class__, self)._tag_part
                return tag_part

            @property
            def _release(self):
                return super(self.__class__, self)._release + [
                    jg_release.JobGraphElementNewTagTagged(
                        job_params={
                            "frequency": (jg_utils.TestFrequency.CHECK_EACH_COMMIT, None),
                            "observed_paths": PROJECT_PATHS,
                        },
                    ),
                    jg_build.JobGraphElementYaMakeBuildTagged(
                        ctx={
                            common_const.BUILD_TYPE_KEY: common_const.PROFILE_BUILD_TYPE,
                            common_const.STRIP_BINARIES: True,
                            "targets": "quality/functionality/rtx/trends/ya_stroka",
                            "arts": "quality/functionality/rtx/trends/ya_stroka/server/server",
                            "result_rt": "YA_STROKA_BINARY",
                            "result_single_file": True,
                            "result_rd": "Server executable for yastoka.yandex.net (tagged)",
                        },
                        # Dict value is resource ttl in days.
                        out={"YA_STROKA_BINARY": 14},
                    ),
                    jg_prerelease.JobGraphElementPreliminaryChangelogTagged(),
                    jg_prerelease.JobGraphElementStartrek(),
                    jg_prerelease.JobGraphElementWiki(),
                    jg_release.JobGraphElementReleaseTagged(
                        task_name="RELEASE_RM_COMPONENT_2",
                        release_to=rm_const.ReleaseStatus.testing,
                        wait_for_deploy=True,
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny.name,
                                "comment_in_linked_tickets": False
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "ya_stroka_res_id",
                                        "YA_STROKA_BINARY",
                                    )
                                ),
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                jg_job_data.ParentDataOutput("major_release_num", "new_tag_number")
                            ),
                            jg_job_triggers.JobTriggerWiki(),
                        ),
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="RUN_PYTHON_SCRIPT",
                        job_params={
                            "job_name_parameter": "SANITY",
                            "ctx": {
                                "script_url": "arcadia:/arc/trunk/arcadia/quality/trailer/suggest/services/searchlib/scripts/test",
                                "cmdline": "-V;  python3 surface.py --host http://yastroka-test-yp-4.sas.yp-c.yandex.net",
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerRelease(
                                job_name_parameter="TESTING"
                            ),
                        )
                    ),
                    jg_test.JobGraphElementTestTagCommon(
                        task_name="SHOOT_VIA_TANKAPI",
                        job_params={
                            "job_name_parameter": "PERFORMANCE",
                            "ctx": {
                                "nanny_service": "yastroka-test-yp",
                                "use_public_tanks": True,
                                "logs_to_save": ["answ*.log", "tank*.log", "jobno*.txt", "autostop*.txt"],
                                "config_source": "arcadia",
                                "config_arc_path": "quality/trailer/suggest/services/searchlib/scripts/test/tank_config.yaml",
                                "ammo_source": "in_config",
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="SANITY"
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.testing,
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                job_name_parameter="PERFORMANCE"
                            ),
                        )
                    ),
                    jg_release.JobGraphElementReleaseTagged(
                        task_name="RELEASE_RM_COMPONENT_2",
                        release_to=rm_const.ReleaseStatus.stable,
                        wait_for_deploy=True,
                        job_params={
                            "ctx": {
                                "deploy_system": rm_const.DeploySystem.nanny.name,
                                "comment_in_linked_tickets": False
                            }
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "ya_stroka_res_id",
                                        "YA_STROKA_BINARY",
                                    )
                                ),
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                jg_job_data.ParentDataOutput("major_release_num", "new_tag_number")
                            ),
                            jg_job_triggers.JobTriggerActionRelease(
                                job_name_parameter="TESTING"
                            )
                        ),
                    ),
                    jg_release.JobGraphElementActionReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                    ),
                ]

    class Notify(cfg.ReferenceTaggedConfig.Notify):
        use_startrek = True

        class Telegram(cfg.ReferenceTaggedConfig.Notify.Telegram):
            invite_link = "https://t.me/joinchat/Bkar4RYNEGLjW_3iKWGTTw"

        class Mail(cfg.ReferenceTaggedConfig.Notify.Mail):
            mailing_list = [
                "evgen@yandex-team.ru",
            ]

        class Startrek(cfg.ReferenceTaggedConfig.Notify.Startrek):
            # https://wiki.yandex-team.ru/releasemachine/startrekoptions/

            assignee = "drewxa"
            queue = "RTX"
            summary_template = "YaStroka release {}"
            followers = [assignee, 'evgen']

    class ChangelogCfg(cfg.ReferenceTaggedConfig.ChangelogCfg):
        dirs = PROJECT_PATHS
        wiki_page = "rtx/trends/changelogs/"

    def __init__(self):
        super(YaStrokaTaggedCfg, self).__init__()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
