# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.components.configs.ya_tool_based._base as ytb
from sandbox.projects.release_machine.components import configs


class ToolApphostCfg(ytb.YaToolReleasedComponentCfg):
    name = "apphost"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="apphost", component_id=1515),  # 1515 is Apphost Development abc service id
        login="robot-ah-releases"
    )

    class Testenv(ytb.YaToolReleasedComponentCfg.Testenv):
        trunk_task_owner = "APP_HOST"

        class JobGraph(ytb.YaToolReleasedComponentCfg.Testenv.JobGraph):
            _target = "apphost/tools/app_host_launcher"
            _binary_name = "app_host_launcher"

    class ChangelogCfg(ytb.YaToolReleasedComponentCfg.ChangelogCfg):
        dirs = [
            "arcadia/apphost/tools/app_host_launcher",
        ]
