# -*- coding: utf-8 -*-
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components.configs.ya_tool_based import _base as ytb
from sandbox.projects.release_machine.components.job_graph import utils as jg_utils
from sandbox.projects.release_machine.components.job_graph import job_triggers as jg_triggers
from sandbox.projects.release_machine.components.job_graph import job_data as jg_job_data
from sandbox.projects.release_machine.components.job_graph.stages import release_stage as jg_release
from sandbox.projects.release_machine.components import configs as cfg


class IceFlameCfg(ytb.YaToolReleasedComponentCiCfg):
    name = "iceflame"
    responsible = cfg.Responsible(abc=cfg.Abc(service_name="releasemachine"), login="ilyaturuntaev")

    class Releases(ytb.YaToolReleasedComponentCiCfg.Releases):
        _ya_tool_bottle_name = "iceflame"

    class CI(ytb.YaToolReleasedComponentCiCfg.CI):
        a_yaml_dir = "release_machine/iceflame"
        sb_owner_group = "RELEASE_MACHINE"

        ya_make_abs_paths_glob = [
            "release_machine/iceflame/**",
            "release_machine/public/**",
            "release_machine/common_proto/**",
            "sandbox/common/rest/**",
            "sandbox/projects/release_machine/core/const/**",
            "build/ya.make",
        ]

        class JobGraph(ytb.YaToolReleasedComponentCiCfg.CI.JobGraph):
            _target = "release_machine/iceflame/bin"
            _binary_name = "iceflame"

            @property
            def _release(self):

                testing_release_stage = jg_utils.StageReleaseFrequency(rm_const.ReleaseStatus.testing)
                testing_release_job_params = dict(
                    testing_release_stage.frequency_type.get_freq_params(),
                    ctx={
                        "deploy_system": rm_const.DeploySystem.sandbox.name,
                    },
                )
                testing_release_job_arrows = jg_triggers.JobTriggerBuild(
                    parent_job_data=jg_job_data.ParentDataId("build_task_id"),
                )

                return super(self.__class__, self)._release + [
                    jg_release.JobGraphElementReleaseCI(
                        task_name="RELEASE_RM_COMPONENT_2",
                        release_to=testing_release_stage.release_stage,
                        job_params=testing_release_job_params,
                        job_arrows=testing_release_job_arrows,
                    ),
                ]

    class ChangelogCfg(ytb.YaToolReleasedComponentCiCfg.ChangelogCfg):
        observed_paths = [
            "arcadia/release_machine/iceflame",
        ]

    class SvnCfg(ytb.YaToolReleasedComponentCiCfg.SvnCfg):
        start_version = 141  # moved to The CI since 140th tag (was a tagged component)
