from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base


class AnomalyAuditReportCfg(sb_cfg_base.SandboxSingleTaskReleaseCfg):
    name = "anomaly_audit_report"
    description = "Anomaly Audit Report"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="anomaly_audit_report"),
        login="levshukov-v",
    )
    target_task_path = "sandbox/projects/yabs/AnomalyAuditReportSandboxWrapper/bin"

    @property
    def task_binary_resource_additional_attributes(self):
        return {"name": "AnomalyAuditReportResource", "taskbox_enabled": True}

    @property
    def release_to_stable_manually(self):
        return True

    class CI(sb_cfg_base.SandboxSingleTaskReleaseCfg.CI):
        sb_owner_group = "SEARCH-ROBOT"
        grant_config_update_permissions_to_release_machine_robot = False

    class Notify(configs.ReferenceBranchedConfig.Notify):
        use_startrek = True

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "golomolzin"
            queue = "BSRELEASE"
            summary_template = "AnomalyAuditReport release {}"
            add_commiters_as_followers = True
            important_changes_limit = 1000
            followers = [
                "lelby",
                "levshukov-v"
            ]
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 4

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = [
            "sandbox/projects/yabs/AnomalyAuditReport",
            "sandbox/projects/yabs/AnomalyAuditReportSandboxWrapper"
        ]
