# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.config_core.jg.cube.lib import dummy as dummy_cubes
from sandbox.projects.release_machine.components.config_core.jg.cube.lib.nanny import ActivateNannyService, CommitNannyService
from sandbox.projects.release_machine.components.config_core.jg.preset import basic_build_presets
from sandbox.projects.release_machine.core import releasable_items as ri

CLUSTERS = ["sas", "man", "vla"]
SERVICE_CLUSTER_TEMPLATES = ["%s_yabs_hit_models_shard03"]
SERVICES = [template % cluster for cluster in CLUSTERS for template in SERVICE_CLUSTER_TEMPLATES]


class YabsHitModels(configs.ReferenceCIConfig):
    name = "yabs_hit_models"

    responsible = configs.Responsible(
        login="kinan-sarmini",
        abc=configs.Abc(service_name="yabs_models_services")
    )

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "yabs/models_services/hit_models"
        grant_config_update_permissions_to_release_machine_robot = False

        secret = "sec-01desry8fbgvnkbeybem81ferv"
        sb_owner_group = "SEARCH-RELEASERS"

    class JG(basic_build_presets.SingleBuildYaMakeJGCfg):

        def _get_build_cube(self, graph):
            build = super(self.__class__, self)._get_build_cube(graph)
            build.input.update(result_rd="Yabs hit_models daemon")
            build.input.update(result_single_file=True)
            return build

        def _get_release_cubes(self, graph, build):
            result = []

            commit_dummy = dummy_cubes.Dummy(name="confirm_nanny_commit", manual=True, needs=[build])
            result.append(commit_dummy)

            commit_cubes = []
            for service in SERVICES:
                cube = CommitNannyService(
                    service_name=service,
                    needs=[commit_dummy],
                    release_title="[RM] Release %s-%s" % (rm_const.CIJMESPathCommon.MAJOR_RELEASE_NUM, rm_const.CIJMESPathCommon.MINOR_RELEASE_NUM),
                    releasable_items=self.root_cfg.releases_cfg.releasable_items
                )
                commit_cubes.append(cube)
                result.append(cube)

            activate_dummy = dummy_cubes.Dummy(name="confim_nanny_activate", manual=True, needs=commit_cubes)
            result.append(activate_dummy)

            for template in SERVICE_CLUSTER_TEMPLATES:
                required_cube = activate_dummy
                for cluster in CLUSTERS:
                    service = template % cluster
                    cube = ActivateNannyService(
                        service_name=service,
                        needs=[required_cube],
                    )
                    required_cube = cube
                    result.append(cube)

            return result

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yabs_hit_models_daemon",
                    data=ri.SandboxResourceData("YABS_HIT_MODELS_DAEMON", dst_path="yabs_hit_models"),
                    build_data=ri.BuildData(
                        target="search/daemons/begemot/yabs_hit_models",
                        artifact="search/daemons/begemot/yabs_hit_models/yabs_hit_models"
                    ),
                    deploy_infos=[ri.single_nanny_service_push(service) for service in SERVICES]
                )
            ]

        deploy_system = rm_const.DeploySystem.nanny_push

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "kinan-sarmini"
            queue = "YABSMODELSREL"
            dev_queue = "YABSMODELSREL"
            summary_template = u"Приемка Hit Models {}"
            use_task_author_as_assignee = False
            deadline = 7
