# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.stages.pre_release_stage as jg_prerelease
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class YabsLinearModelsCfg(configs.ReferenceTaggedConfig):
    name = "yabs_linear_models"
    responsible = "ilyaturuntaev"

    class Releases(configs.ReferenceTaggedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yabs_linear_models",
                    data=ri.SandboxResourceData("YABS_LINEAR_MODELS_EXECUTABLE"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
            ]

    class Testenv(configs.ReferenceTaggedConfig.Testenv):
        trunk_task_owner = "SEARCH-RELEASERS"

        class JobGraph(configs.ReferenceTaggedConfig.Testenv.JobGraph):
            @property
            def _tag_part(self):
                return [
                    jg_build.JobGraphElementBuildTagged(
                        task_name="KOSHER_YA_MAKE",
                        job_params={
                            "filter_targets": ["search/daemons/begemot/yabs_linear_models"],
                            "frequency": (jg_utils.TestFrequency.RUN_IF_DELAY_N_MINUTES, 30),
                        },
                        out={"YABS_LINEAR_MODELS_EXECUTABLE": 30},
                        ctx={
                            "targets": "search/daemons/begemot/yabs_linear_models/yabs_linear_models",
                            "arts": "search/daemons/begemot/yabs_linear_models/yabs_linear_models",
                            "result_rt": "YABS_LINEAR_MODELS_EXECUTABLE",
                            "result_single_file": True,
                        },
                    ),
                    jg_prerelease.JobGraphElementPreliminaryChangelogTagged(),
                ]

            @property
            def _release(self):
                return super(self.__class__, self)._release + [
                    jg_release.JobGraphElementNewTagTagged(),
                    jg_release.JobGraphElementReleaseTagged(
                        release_to=rm_const.ReleaseStatus.stable,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "yabs_linear_models",
                                        "YABS_LINEAR_MODELS_EXECUTABLE",
                                    ),
                                )
                            ),
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseTagged(rm_const.ReleaseStatus.stable),
                ]

    class Notify(configs.ReferenceTaggedConfig.Notify):
        use_startrek = False

    class ChangelogCfg(configs.ReferenceTaggedConfig.ChangelogCfg):
        dirs = [
            "arcadia/search/daemons/begemot/yabs_linear_models",
        ]
        wiki_page = ""

    def __init__(self):
        super(YabsLinearModelsCfg, self).__init__()
        self.changelog_cfg = self.ChangelogCfg(self, self.svn_cfg.main_url, self.responsible)
