from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.components.configs.sb_tasks import _base as sb_cfg_base


class PartnerShareCfg(sb_cfg_base.SandboxSingleTaskReleaseCfg):
    name = "partner_share"
    description = "Partner Share"
    responsible = configs.Responsible(
        abc=configs.Abc(service_name="tacman"),
        login="levshukov-v",
    )
    target_task_path = "sandbox/projects/yabs/partner_share/bin"

    @property
    def task_binary_resource_additional_attributes(self):
        return {"name": "TacmanBinaryResource"}

    @property
    def release_to_stable_manually(self):
        return True

    class CI(sb_cfg_base.SandboxSingleTaskReleaseCfg.CI):
        sb_owner_group = "SEARCH-ROBOT"
        grant_config_update_permissions_to_release_machine_robot = False

    class Notify(configs.ReferenceBranchedConfig.Notify):
        use_startrek = True

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "golomolzin"
            queue = "BSRELEASE"
            summary_template = "PartnerShare release {}"
            add_commiters_as_followers = True
            important_changes_limit = 1000
            followers = [
                "damirzain",
                "okwedook",
                "levshukov-v"
            ]
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 4

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = ""
        observed_paths = [
            "sandbox/projects/yabs/partner_share"
        ]
