# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class YabsServerL7BalancerCfg(configs.ReferenceBranchedConfig):
    name = "yabs_server_l7balancer"
    responsible = "rmcf"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "YANDEX_MONETIZE_BANNER_RT"
        branch_db_template = "yabs-server-l7balancer-{testenv_db_num}"

        @staticmethod
        def db_stop_range(branch_number):
            stop_range = range(max([branch_number - 4, 1]), branch_number - 2)
            return stop_range

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementBuildPackageBranched(
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 10 * 1024 ** 3,  # 10 Gb
                                },
                            }
                        },
                        package_names="yabs/balancing/package/pkg.json",
                        resource_names="YABS_SERVER_L_7_BALANCER",
                        out={
                            "YABS_SERVER_L_7_BALANCER": 360,
                        },
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YABS_SERVER_REPORT_BUILD",
                        build_item="REPORT",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "yabs_server_l7balancer_binary",
                                        "YABS_SERVER_L_7_BALANCER",
                                    )
                                )
                            )
                        ),
                        ctx={
                            "post_st_comment": True,
                            "binary_executor_release_type": "none",
                        },
                    ),
                    jg_test.JobGraphElementTrunkWaiter(),
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="MOVE_STARTREK_TICKET",
                        job_params={
                            "job_name_parameter": "STARTREK_TRANSITION_{}".format(rm_const.ReleaseStatus.testing),
                        },
                        job_arrows=(
                            jg_arrows.ParamsData("release_num", jg_utils.get_major_release_number),
                        ),
                        ctx={
                            "transition": "passed",
                        }
                    ),
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = [
                    jg_release.JobGraphElementReleaseBranched(
                        release_to=rm_const.ReleaseStatus.testing,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "yabs_server_l7balancer_binary",
                                        "YABS_SERVER_L_7_BALANCER",
                                    )
                                )
                            )
                        )
                    ),
                    jg_release.JobGraphElementActionReleaseBranched(
                        release_to=rm_const.ReleaseStatus.testing,
                    )
                ]
                return default_release_part + release_part

        class JobPatch(configs.ReferenceBranchedConfig.Testenv.JobPatch):
            """TestEnv Job Patch"""

            @property
            def change_frequency(self):
                tests = super(self.__class__, self).change_frequency
                tests.update({
                    "_{}_REPORT_BUILD".format(self.name.upper()): rm_const.TestFrequencies.EACH_REV_TEST,
                })
                return tests

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yabs_server_l7balancer_binary",
                    data=ri.SandboxResourceData("YABS_SERVER_L_7_BALANCER"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
            ]
        release_followers_permanent = [
            "bahbka",
            "fdrstrok",
            "maslovskiy",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["yabs-server_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "bahbka"
            dev_queue = "YABS"
            queue = "BSRELEASE"
            summary_template = u"Релиз движковый балансер {}"
            workflow = {}
            followers = [
                "fdrstrok",
                "bahbka",
                "maslovskiy",
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 4

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "bannernajakrutilka/server/l7balancer/changelog/"
        ya_make_targets = [
            "arcadia/yabs/balancing",
        ]
        svn_paths_filter = configs.ChangelogPathsFilter(rm_const.PermissionType.CHANGED, ["arcadia/yabs/balancing"], 5)

        @staticmethod
        def calculate_importance(changelog_entry):
            for action, path in changelog_entry.revision_paths:
                if "yabs/balancing" in path:
                    return 5
            return min(3, changelog_entry.mark)

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "yabs/infra/l7balancer"
