# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.core.const as rm_const
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class YabsServerValidatorCfg(configs.ReferenceBranchedConfig):
    name = "yabs_server_validator"
    responsible = "rmcf"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "YANDEX_MONETIZE_BANNER_RT"
        branch_db_template = "yabs-server-validator-{testenv_db_num}"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            RELEASE_MODE_TO_NANNY_PARAMS = {
                rm_const.ReleaseStatus.testing: {
                    "dashboard_id": "bsfront_infra",
                    "recipe_names": ["bsfront_infra.yaml"],  # deprecated
                    "recipe_name": "bsfront_infra.yaml",
                },
                rm_const.ReleaseStatus.stable: {
                    "dashboard_id": "bsfront_production",
                    "recipe_names": ["bsfront_universal_by_segment.yaml"],  # deprecated
                    "recipe_name": "bsfront_universal_by_segment.yaml",
                }
            }

            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part
                branch_part = [
                    jg_build.JobGraphElementBuildPackageBranched(
                        job_params={
                            "apiargs": {
                                "requirements": {
                                    "disk_space": 10 * 1024 ** 3,  # 10 Gb
                                },
                            },
                        },
                        package_names=";".join([
                            "yabs/server/infra/validator/yabs-server-base-validator.json",
                            "yabs/server/infra/validator/yabs-server-base-validator-hooks.json",
                        ]),
                        resource_names=";".join([
                            "YABS_SERVER_VALIDATOR",
                            "YABS_SERVER_VALIDATOR_HOOKS",
                        ]),
                        out={
                            "YABS_SERVER_VALIDATOR": 30,
                            "YABS_SERVER_VALIDATOR_HOOKS": 30,
                        },
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YABS_SERVER_REPORT_BUILD",
                        job_params={
                            "job_name_parameter": "REPORT",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="yabs_server_validator_binary",
                                        resource_name="YABS_SERVER_VALIDATOR",
                                    ),
                                    jg_job_data.ParentDataDict(
                                        input_key="component_resources",
                                        dict_key="yabs_server_validator_hooks_binary",
                                        resource_name="YABS_SERVER_VALIDATOR_HOOKS",
                                    ),
                                )
                            )
                        ),
                        ctx={
                            "post_st_comment": True,
                            "binary_executor_release_type": "none",
                        },
                    ),
                    jg_test.JobGraphElementTrunkWaiter(),
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release
                release_part = []
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(
                        jg_test.JobGraphElementTestBranchCommon(
                            task_name="YABS_SERVER_DEPLOY_NANNY_DASHBOARD",
                            job_params={
                                "job_type": rm_const.JobTypes.DEPLOY,
                                "job_name_parameter": release_stage,
                            },
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataId(
                                            input_key="build_task",
                                        ),
                                    ),
                                ),
                                jg_arrows.ParamsData(
                                    input_key="major_version",
                                    transform=jg_utils.get_major_release_number,
                                ),
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput(
                                            input_key="minor_version",
                                            output_key="new_tag_number",
                                        ),
                                    ),
                                ),
                            ),
                            ctx={
                                "wait_deploy": True,
                                "nanny_oauth_token_name": "YABS_RELEASER_NANNY_TOKEN",
                                "release_type": release_stage,
                                "dashboard_id": self.RELEASE_MODE_TO_NANNY_PARAMS[release_stage]["dashboard_id"],
                                "recipe_names": self.RELEASE_MODE_TO_NANNY_PARAMS[release_stage]["recipe_names"],  # deprecated
                                "recipe_name": self.RELEASE_MODE_TO_NANNY_PARAMS[release_stage]["recipe_name"],
                                "resource_types_to_update": [
                                    "YABS_SERVER_VALIDATOR",
                                    "YABS_SERVER_VALIDATOR_HOOKS",
                                ],
                            },
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=(
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="yabs_server_validator_binary",
                                            resource_name="YABS_SERVER_VALIDATOR",
                                        ),
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="yabs_server_validator_hooks_binary",
                                            resource_name="YABS_SERVER_VALIDATOR_HOOKS",
                                        ),
                                    )
                                )
                            )
                        )
                    )
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage,
                            job_arrows=(
                                jg_job_triggers.JobTriggerTestBranchCommon(
                                    job_type=rm_const.JobTypes.DEPLOY,
                                    job_name_parameter=release_stage,
                                )
                            )
                        )
                    )
                return default_release_part + release_part

    class Releases(configs.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yabs_server_validator_binary",
                    data=ri.SandboxResourceData("YABS_SERVER_VALIDATOR"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
                ri.ReleasableItem(
                    name="yabs_server_validator_hooks_binary",
                    data=ri.SandboxResourceData("YABS_SERVER_VALIDATOR_HOOKS"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
            ]
        release_followers_permanent = [
            "bahbka",
            "fdrstrok",
        ]

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Telegram(configs.ReferenceBranchedConfig.Notify.Telegram):
            chats = ["yabs-server_comp"]
            config = configs.RmTelegramNotifyConfig(chats=chats)

        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "rmcf"
            assignee_after_acceptance = "rmcf"
            dev_queue = "YABS"
            queue = "BSRELEASE"
            summary_template = u"Релиз валидатор {}"
            workflow = {}
            followers = [
                "fdrstrok",
                "bahbka",
            ]
            add_commiters_as_followers = False
            use_task_author_as_assignee = False
            deadline = 7
            commit_importance_threshold = 4

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        wiki_page = "bannernajakrutilka/server/validator/changelog/"
        ya_make_targets = [
            "arcadia/yabs/server/infra/validator",
        ]
        svn_paths_filter = configs.ChangelogPathsFilter(
            rm_const.PermissionType.CHANGED, ["arcadia/yabs/server/infra/validator"], 5
        )

        @staticmethod
        def calculate_importance(changelog_entry):
            for action, path in changelog_entry.revision_paths:
                if "yabs/server/infra/validator" in path:
                    return 5
            return min(3, changelog_entry.mark)

    class SvnCfg(configs.ReferenceBranchedConfig.SvnCfg):
        branch_name = "yabs/infra/validator"
