# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri

import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows


class AutoSupBsCfg(cfg.ReferenceBranchedConfig):
    name = "autosupbs"
    responsible = "levshukov-v"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "AUTOSUPBS"

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="DEPLOY_BINARY_TASK",
                        out={"SANDBOX_TASKS_BINARY": 30},
                        ctx={
                            "target": "sandbox/projects/yabs/auto_supbs_2/bin/auto-supbs-2",
                            "attrs": {"name": "autosupbs_2"},
                            "yt_token_vault": "ROBOT_AUTOSUPBS_YT_TOKEN",
                        },
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key="arcadia_url",
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataOutput("result_path", "result_path"),
                                        ),
                                    ),
                                ),
                                transform=lambda result_path: "{}/arcadia".format(result_path),
                            ),
                        ),
                    ),
                )
                return branch_part

            @property
            def _release(self):
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(jg_release.JobGraphElementReleaseBranched(
                        release_to=release_stage,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                jg_job_data.ParentDataDict("component_resources", "autosupbs_2", "SANDBOX_TASKS_BINARY"),
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                                    jg_job_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                                ),
                            ),
                        ),
                    ))
                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        release_to=release_stage,
                    ))
                return release_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "kenig"
            queue = "BSRELEASE"
            summary_template = "AutoSupBs release {}"
            add_commiters_as_followers = True

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/sandbox/projects/yabs/auto_supbs_2",
        ]
        wiki_page = ""

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        allow_old_releases = True
        allow_robots_to_release_stable = True

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="autosupbs_2",
                    data=ri.SandboxResourceData("SANDBOX_TASKS_BINARY", attributes={"name": "autosupbs_2"}),
                    deploy_infos=[ri.SandboxInfo()]
                ),
            ]
