# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class DirectMonitoringCfg(configs.ReferenceBranchedConfig):
    display_name = "DirectMonitoring"
    name = "direct_monitoring"
    responsible = "antikov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "DIRECT_MONITORING"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part

                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_PACKAGE",
                        job_params={
                            "apiargs": {
                                "kill_timeout": 3600,
                            },
                        },
                        ctx={
                            "use_aapi_fuse": True,
                            "aapi_fallback": True,
                            "build_type": "release",
                            "packages": "yabs/stat/direct_monitoring/package.json",
                            "package_type": "tarball",
                            "release_to_ya_deploy": True,
                            "yp_token_vault": "YABS_STARTREK_YP_TOKEN",
                            "resource_type": "DIRECT_MONITORING_PACKAGE",
                        },
                        out={"DIRECT_MONITORING_PACKAGE": 30},
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release

                release_part = []
                releases = {
                    rm_const.ReleaseStatus.stable: (jg_utils.TestFrequency.LAZY, None),
                    rm_const.ReleaseStatus.testing: (jg_utils.TestFrequency.LAZY, None),
                }

                for release_stage, frequency in releases.items():
                    release_part.extend([
                        jg_release.JobGraphElementActionReleaseBranched(
                            job_params={
                                "frequency": frequency,
                            },
                            release_to=release_stage,
                        ),
                        jg_release.JobGraphElementReleaseBranched(
                            task_name="RELEASE_RM_COMPONENT_2",
                            release_to=release_stage,
                            job_params={
                                "ctx": {
                                    "deploy_system": rm_const.DeploySystem.sandbox.name,
                                }
                            },
                            job_arrows=[
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=[
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="DIRECT_MONITORING_PACKAGE",
                                            resource_name="DIRECT_MONITORING_PACKAGE",
                                        ),
                                    ],
                                ),
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                                        jg_job_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                                    ),
                                ),
                            ],
                        )
                    ])

                return default_release_part + release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "antikov"
            queue = "BSRELEASE"
            summary_template = "Direct-Monitoring Release {}"
            followers = [
                "antikov"
            ]
            deadline = 7
            notify_on_deploy_to_feature_st_tickets = True
            notify_on_release_to_release_st_ticket = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/yabs/stat/direct_monitoring/",
        ]
        wiki_page = "users/antikov/directmonitoring/Relizy-Direct-Monitoring/"

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        allow_old_releases = True
        wait_for_deploy_time_sec = 120

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="DIRECT_MONITORING_PACKAGE",
                    data=ri.SandboxResourceData("DIRECT_MONITORING_PACKAGE"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
            ]
