# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class DropstatApiCfg(configs.ReferenceBranchedConfig):
    display_name = "Dropstat"
    name = "dropstat"
    responsible = "nikondr"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "YABS_DROP_STAT"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part

                branch_part = [
                    jg_build.JobGraphElementBuildBranched(
                        task_name="DEPLOY_BINARY_TASK",
                        build_item="DROPSTAT_TASKS",
                        ctx={
                            "target": "sandbox/projects/yabs/dropstat/bin/YabsDropStat",
                            "attrs": {"name": "YabsDropStat"},
                            "yt_token_vault": "robot-yabs-dropstat-yt-token",
                        },
                        out={"SANDBOX_TASKS_BINARY": 30},
                        job_arrows=(
                            jg_arrows.ParentsData(
                                input_key="arcadia_url",
                                triggers=(
                                    jg_job_triggers.JobTriggerNewTag(
                                        parent_job_data=(
                                            jg_job_data.ParentDataOutput("result_path", "result_path"),
                                        ),
                                    ),
                                ),
                                transform=lambda result_path: "{}/arcadia".format(result_path),
                            ),
                        ),
                    ),
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_MAKE",
                        build_item="DROPSTAT_BINARY",
                        ctx={
                            "targets": "yabs/stat/dropstat2/bin/package",
                            "result_rt": "YABS_DROP_STAT_BINARY_PACKAGE",
                            "arts": "yabs/stat/dropstat2/bin/package/merge;yabs/stat/dropstat2/bin/package/ytpump",
                            "ya_yt_token_vault_name": "robot-yabs-dropstat-yt-token",
                            "checkout": True,
                        },
                        out={"YABS_DROP_STAT_BINARY_PACKAGE": 30},
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release

                release_part = []

                for release_stage in [rm_const.ReleaseStatus.prestable, rm_const.ReleaseStatus.stable]:
                    release_part.append(jg_release.JobGraphElementReleaseBranched(
                        release_to=release_stage,
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="DROPSTAT_TASKS",
                                parent_job_data=jg_job_data.ParentDataDict("component_resources", "dropstat_tasks", "SANDBOX_TASKS_BINARY"),
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                job_name_parameter="DROPSTAT_BINARY",
                                parent_job_data=jg_job_data.ParentDataDict("component_resources", "dropstat_binary", "YABS_DROP_STAT_BINARY_PACKAGE"),
                            ),
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                                    jg_job_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                                    jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                                ),
                            ),
                        ),
                    ))
                    release_part.append(jg_release.JobGraphElementActionReleaseBranched(
                        release_to=release_stage,
                    ))

                return default_release_part + release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "nikondr"
            queue = "BSRELEASE"
            summary_template = "Dropstat Release {}"
            followers = [
                "nikondr",
                "danilgrig",
            ]
            add_commiters_as_followers = True
            notify_on_deploy_to_feature_st_tickets = True
            notify_on_release_to_release_st_ticket = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/sandbox/projects/yabs/dropstat",
            "arcadia/yabs/stat/dropstat2/libs",
            "arcadia/yabs/stat/dropstat2/pylibs",
            "arcadia/yabs/stat/dropstat2/bin",
        ]
        wiki_page = ""

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        allow_old_releases = True

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="dropstat_tasks",
                    data=ri.SandboxResourceData("SANDBOX_TASKS_BINARY"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
                ri.ReleasableItem(
                    name="dropstat_binary",
                    data=ri.SandboxResourceData("YABS_DROP_STAT_BINARY_PACKAGE"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
            ]
