# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils
from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class DropstatApiCfg(configs.ReferenceBranchedConfig):
    display_name = "Dropstat API"
    name = "dropstat_api"
    responsible = "smalahov"

    class Testenv(configs.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "YABS_DROP_STAT"

        class JobGraph(configs.ReferenceBranchedConfig.Testenv.JobGraph):
            @property
            def _branch_part(self):
                default_branch_part = super(self.__class__, self)._branch_part

                branch_part = [
                    jg_build.JobGraphElementYaMakeBuildBranched(
                        task_name="YA_PACKAGE",
                        job_params={
                            "apiargs": {
                                "kill_timeout": 3600,
                            },
                        },
                        ctx={
                            "use_aapi_fuse": True,
                            "aapi_fallback": True,
                            "build_type": "release",
                            "packages": "yabs/stat/dropstat2/api/package.json",
                            "package_type": "tarball",
                            "release_to_ya_deploy": True,
                            "yp_token_vault": "ROBOT_YABS_DROPSTAT_YP_TOKEN",
                            "resource_type": "YABS_DROP_STAT_API_PACKAGE",
                        },
                        out={"YABS_DROP_STAT_API_PACKAGE": 30},
                    )
                ]
                return default_branch_part + branch_part

            @property
            def _release(self):
                default_release_part = super(self.__class__, self)._release

                release_part = []
                releases = {
                    rm_const.ReleaseStatus.stable: (jg_utils.TestFrequency.LAZY, None),
                    rm_const.ReleaseStatus.prestable: (jg_utils.TestFrequency.LAZY, None),
                }

                for release_stage, frequency in releases.items():
                    release_part.extend([
                        jg_release.JobGraphElementActionReleaseBranched(
                            job_params={
                                "frequency": frequency,
                            },
                            release_to=release_stage,
                        ),
                        jg_release.JobGraphElementReleaseBranched(
                            task_name="RELEASE_RM_COMPONENT_2",
                            release_to=release_stage,
                            job_params={
                                "ctx": {
                                    "deploy_system": rm_const.DeploySystem.sandbox.name,
                                }
                            },
                            job_arrows=[
                                jg_job_triggers.JobTriggerBuild(
                                    parent_job_data=[
                                        jg_job_data.ParentDataDict(
                                            input_key="component_resources",
                                            dict_key="DROPSTAT_API_PACKAGE",
                                            resource_name="YABS_DROP_STAT_API_PACKAGE",
                                        ),
                                    ],
                                ),
                                jg_job_triggers.JobTriggerNewTag(
                                    parent_job_data=(
                                        jg_job_data.ParentDataOutput("major_release_num", "branch_number_for_tag"),
                                        jg_job_data.ParentDataOutput("minor_release_num", "new_tag_number"),
                                    ),
                                ),
                            ],
                        )
                    ])

                return default_release_part + release_part

    class Notify(configs.ReferenceBranchedConfig.Notify):
        class Startrek(configs.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "kenig"
            queue = "BSRELEASE"
            summary_template = "Dropstat API Release {}"
            followers = [
                "kenig"
            ]
            deadline = 7
            notify_on_deploy_to_feature_st_tickets = True
            notify_on_release_to_release_st_ticket = True

    class ChangelogCfg(configs.ReferenceBranchedConfig.ChangelogCfg):
        dirs = [
            "arcadia/yabs/stat/dropstat2/api/",
        ]
        wiki_page = ""

    class Releases(configs.ReferenceBranchedConfig.Releases):
        allow_robots_to_release_stable = True
        allow_old_releases = True
        wait_for_deploy_time_sec = 120

        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="DROPSTAT_API_PACKAGE",
                    data=ri.SandboxResourceData("YABS_DROP_STAT_API_PACKAGE"),
                    deploy_infos=[ri.SandboxInfo()]
                ),
            ]
