# -*- coding: utf-8 -*-

from sandbox.projects.release_machine.components import configs as cfg
from sandbox.projects.release_machine.components.config_core import yappy as yappy_cfg
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri
from sandbox.projects.common.constants import constants as common_const
import sandbox.projects.release_machine.components.job_graph.stages.release_stage as jg_release
import sandbox.projects.release_machine.components.job_graph.stages.build_stage as jg_build
import sandbox.projects.release_machine.components.job_graph.stages.test_stage as jg_test
import sandbox.projects.release_machine.components.job_graph.job_data as jg_job_data
import sandbox.projects.release_machine.components.job_graph.job_triggers as jg_job_triggers
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class YdoSearchproxyCfg(cfg.ReferenceBranchedConfig):
    component_group = 'reference_component_metricsed'
    name = "ydo_searchproxy"
    display_name = "Ydo-searchproxy"
    responsible = "muzich"

    class Testenv(cfg.ReferenceBranchedConfig.Testenv):
        trunk_task_owner = "YDO"
        trunk_db = "ydo-searchproxy-trunk"
        branch_db_template = "ydo-searchproxy-{testenv_db_num}"

        class JobGraph(cfg.ReferenceBranchedConfig.Testenv.JobGraph):

            @staticmethod
            def _beta_name_to_url_prefix(beta_name, _):
                return "{beta_name}.hamster".format(beta_name=beta_name)

            @property
            def _branch_part(self):
                branch_part = super(self.__class__, self)._branch_part
                branch_part.append(
                    jg_build.JobGraphElementBuildBranched(
                        task_name="KOSHER_YA_MAKE",
                        job_params={
                            "job_name_parameter": "RELEASE",
                        },
                        out={"YDO_SAAS_SEARCH_PROXY": 180},
                        ctx={
                            "aapi_fallback": False,
                            "strip_binaries": False,
                            common_const.CHECKOUT_MODE: common_const.CHECKOUT_MODE_AUTO,
                            "targets": "extsearch/ydo/searchproxy",
                            "arts": "extsearch/ydo/searchproxy/searchproxy",
                            "result_rt": "YDO_SAAS_SEARCH_PROXY",
                            "result_single_file": True,
                            "use_arc_instead_of_aapi": True,
                            "ya_yt_token_vault_owner": "YDO",
                            "ya_yt_token_vault_name": "yt-token"
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerNewTag(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                                    jg_job_data.ParentDataId("tag"),
                                ),
                            )
                        ),
                    ),
                )
                branch_part.append(
                    jg_test.JobGraphElementYappyBetaGeneratorBranched(
                        beta_conf_type="web",
                        job_arrows=(
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataDict(
                                        "component_resources",
                                        "ydo_searchproxy",
                                        "YDO_SAAS_SEARCH_PROXY",
                                    ),
                                ),
                                job_name_parameter="RELEASE",
                            ),

                        )
                    )
                )
                branch_part.append(
                    jg_test.JobGraphElementLaunchMetrics(
                        search_subtype="web",
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key='checked_beta',
                                        output_key='beta_name',
                                        transform=self._beta_name_to_url_prefix,
                                    )
                                ),
                                job_name_parameter="WEB",
                            )
                        ),
                        ctx={
                            "beta_conf_type": "ydo-searchproxy-prestable",
                            "custom_template_name": "ydo_searchproxy.json",
                            "scraper_over_yt_pool": "geo_continues_upper_test",
                            "sample_beta": "hamster",
                        }
                    )
                )

                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="YDO_SEARCHPROXY_GET_RESPONSES",
                        job_params={
                            "task_priority": 7,
                            "job_name_parameter": "GET_RESPONSES_BETA",
                        },
                        out={
                            "YDO_SEARCHPROXY_TEST_WIZARD_RESPONSES": 14,
                            "YDO_SEARCHPROXY_TEST_PORTAL_RESPONSES": 14,
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerGenerateBeta(
                                parent_job_data=(
                                    jg_job_data.ParentDataCtx(
                                        input_key="url_prefix",
                                        output_key="beta_name",
                                        transform=self._beta_name_to_url_prefix,
                                    )
                                ),
                                job_name_parameter="WEB",
                            ),
                            jg_arrows.ParamsData(
                                input_key='revision',
                                transform=lambda x, rm_config: x.revision,
                                override=True,
                            )
                        )
                    )
                )

                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="YDO_SEARCHPROXY_GET_RESPONSES",
                        job_params={
                            "task_priority": 7,
                            "job_name_parameter": "GET_RESPONSES_HAMSTER",
                        },
                        job_arrows=(
                            jg_arrows.ParamsData(
                                input_key='revision',
                                transform=lambda x, rm_config: x.revision,
                                override=True,
                            )
                        ),
                        out={
                            "YDO_SEARCHPROXY_TEST_WIZARD_RESPONSES": 14,
                            "YDO_SEARCHPROXY_TEST_PORTAL_RESPONSES": 14,
                        },
                    )
                )

                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="YDO_SEARCHPROXY_RESPONSE_DIFF",
                        job_params={
                            "task_priority": 7,
                            "job_name_parameter": "RESPONSE_DIFF",
                        },
                        job_arrows=(
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="wizard_resource_1",
                                        resource_name="YDO_SEARCHPROXY_TEST_WIZARD_RESPONSES",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="portal_resource_1",
                                        resource_name="YDO_SEARCHPROXY_TEST_PORTAL_RESPONSES",
                                    )
                                ),
                                job_name_parameter="GET_RESPONSES_HAMSTER",
                            ),
                            jg_job_triggers.JobTriggerTestBranchCommon(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="wizard_resource_2",
                                        resource_name="YDO_SEARCHPROXY_TEST_WIZARD_RESPONSES",
                                    ),
                                    jg_job_data.ParentDataResource(
                                        input_key="portal_resource_2",
                                        resource_name="YDO_SEARCHPROXY_TEST_PORTAL_RESPONSES",
                                    )
                                ),
                                job_name_parameter="GET_RESPONSES_BETA",
                            )
                        )
                    )
                )

                acceptance_job_arrows = (
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="RESPONSE_DIFF"),
                    jg_job_triggers.JobTriggerLaunchMetrics(job_name_parameter="WEB"),
                    jg_job_triggers.JobTriggerTestBranchCommon(job_name_parameter="COMPARE_MIDDLESEARCH_BINARIES")
                )

                branch_part.append(
                    jg_test.JobGraphElementActionRunAcceptanceBranched(
                        job_arrows=acceptance_job_arrows,
                        frequency=(jg_utils.TestFrequency.CHECK_EACH_COMMIT, None)
                    )
                )

                branch_part.append(
                    jg_test.JobGraphElementTestBranchCommon(
                        task_name="COMPARE_MIDDLESEARCH_BINARIES",
                        job_params={
                            "task_priority": 7,
                            "job_name_parameter": "COMPARE_MIDDLESEARCH_BINARIES"
                        },
                        ctx={
                            "calc_mode": "ydo",
                            "launch_mode": "YDO"
                        },
                        job_arrows=(
                            jg_arrows.GlobalResourceData(
                                "middlesearch_evlogdump_resource_id", "YDO_EVLOGDUMP_EXECUTABLE"
                            ),
                            jg_job_triggers.JobTriggerBuild(
                                parent_job_data=(
                                    jg_job_data.ParentDataResource(
                                        input_key="binary_first",
                                        resource_name="YDO_SAAS_SEARCH_PROXY"
                                    )
                                ),
                                job_name_parameter="RELEASE"
                            )
                        )
                    )
                )

                return branch_part

            @property
            def _release(self):
                build_resources_info = (
                    jg_job_triggers.JobTriggerBuild(
                        parent_job_data=(
                            jg_job_data.ParentDataDict(
                                "component_resources", "ydo_searchproxy", "YDO_SAAS_SEARCH_PROXY"
                            ),
                        ),
                        job_name_parameter="RELEASE",
                    ),
                    jg_job_triggers.JobTriggerNewTag(
                        parent_job_data=(
                            jg_job_data.ParentDataCtx("release_number", "scope_number", override=True),
                        ),
                    ),
                )
                release_part = super(self.__class__, self)._release
                for release_stage in [rm_const.ReleaseStatus.testing, rm_const.ReleaseStatus.stable]:
                    release_part.append(jg_release.JobGraphElementReleaseBranched(
                        release_to=release_stage,
                        wait_for_deploy=True,
                        job_arrows=build_resources_info,
                    ))
                    release_part.append(
                        jg_release.JobGraphElementActionReleaseBranched(
                            release_to=release_stage
                        )
                    )

                return release_part

    class Notify(cfg.ReferenceBranchedConfig.Notify):
        class Startrek(cfg.ReferenceBranchedConfig.Notify.Startrek):
            assignee = "muzich"
            queue = "YDO"
            followers = [assignee, 'alextim27']
            summary_template = "YDO searchproxy acceptance {}"
            use_task_author_as_assignee = True
            hide_commits_under_cut = True

    class ChangelogCfg(cfg.ReferenceBranchedConfig.ChangelogCfg):
        ya_make_targets = [
            "arcadia/extsearch/ydo/searchproxy"
        ]
        wiki_page = ""
        svn_paths_filter = cfg.ChangelogPathsFilter(
            rm_const.PermissionType.ALLOWED,
            [
                "arcadia/extsearch/ydo/include",
                "arcadia/extsearch/ydo/lib",
                "arcadia/extsearch/ydo/proto",
                "arcadia/extsearch/ydo/saas_rearrange",
                "arcadia/extsearch/ydo/searchproxy",
                "arcadia/kernel/ydo"
            ]
        )

    class SvnCfg(cfg.ReferenceBranchedConfig.SvnCfg):
        branches_folder = "branches/ydo"
        tags_folder = "tags/ydo"
        branch_name = "ydo-searchproxy"
        tag_name = "ydo-searchproxy"

    class Releases(cfg.ReferenceBranchedConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="ydo_searchproxy",
                    data=ri.SandboxResourceData("YDO_SAAS_SEARCH_PROXY"),
                    deploy_infos=[
                        ri.single_nanny_service("ydo-searchproxy"),
                        ri.single_nanny_service("ydo-searchproxy-prestable", rm_const.ReleaseStatus.testing),
                    ]
                ),
            ]
        wait_for_deploy_time_sec = 1 * 60 * 60

    class MetricsCfg(cfg.ReferenceBranchedConfig.MetricsCfg):
        run_bisect = True

    class Yappy(cfg.ReferenceBranchedConfig.Yappy):
        wait_for_deploy_time_sec = 1 * 60 * 60
        _resources = [
            yappy_cfg.YappyParametrizedResource(
                local_path="searchproxy",
                param_name="ydo_searchproxy",
            ),
        ]
        betas = {
            "web": yappy_cfg.YappyTemplateCfg(
                template_name="ydo-searchproxy-prestable",
                patches=[
                    yappy_cfg.YappyTemplatePatch(
                        patch_dir="ydo_searchproxy",
                        resources=_resources,
                        parent_service="ydo-searchproxy-hamster",
                        ignore_instance_spec=True,
                    ),
                ],
                new_yappy=True,
            ),
        }
