# -*- coding: utf-8 -*-

from . import _yp_core as core

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class YPExportCfg(core.YPConfigBase):
    name = "yp_export"

    class JG(core.YPJobGraph):
        yp_test_cubes = [
            core.YPTestCube(
                name="test",
                paths=[
                    "infra/libs/controller",
                    "yp/cpp/yp",
                    "yp/export",
                ],
            ),
        ]

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "yp/export/daemons/yp_export"
        secret = "sec-01fgrcn7q2t99yw91w2jkrpysc"
        sb_owner_group = "YP"

        ya_make_abs_paths_glob = [
            "infra/libs/controller/**",
            "yp/cpp/yp/**",
            "yp/export/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yp_export_binary",
                    data=ri.SandboxResourceData("YP_EXPORT_BINARY"),
                    build_data=ri.BuildData(
                        target="yp/export/daemons/yp_export/yp_export",
                    ),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService(name)
                                for name in (
                                    "yp-export-iva",
                                    "yp-export-myt",
                                    "yp-export-man",
                                    "yp-export-xdc",
                                    "yp-export-sas",
                                    "yp-export-vla",
                                )
                            ],
                            stage=rm_const.ReleaseStatus.stable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("yp-export-man-pre"),
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("yp-export-sas-test"),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                    ],
                ),
            ]

        allow_old_releases = True
        release_followers_permanent = [
            "bidzilya",
            "se4min",
        ]
        allow_robots_to_release_stable = True

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "yp/releases/export"
        dirs = [
            "arcadia/infra/libs/controller",
            "arcadia/yp/cpp/yp",
            "arcadia/yp/export",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "se4min"
            queue = "YPREL"
            dev_queue = "YP"
            summary_template = u"Release YP Export {}"
            add_commiters_as_followers = False
            deadline = 14
            followers = [
                "bidzilya",
                "se4min",
            ]
            important_changes_limit = 1000
            notify_on_component_versions_change_to_feature_tickets = core.NOTIFY_ON_COMPONENT_VERSION_CHANGE_TO_FEATURE_TICKETS

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        max_active_branches = 4
        start_version = 82  # Moved to the CI since 82th branch.
        branch_name = "yp/export"
        tag_name = "yp/export"
