# -*- coding: utf-8 -*-

from . import _yp_core as core

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri, const as rm_const


class YPHeavySchedulerConfig(core.YPConfigBase):
    name = "yp_heavy_scheduler"

    class JG(core.YPJobGraph):
        yp_test_cubes = [
            core.YPTestCube(
                name="test_yp",
                paths=list(core.YP_TEST_PATHS),
            ),
        ]

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "yp/server/heavy_scheduler/bin"
        secret = "sec-01fgrcn7q2t99yw91w2jkrpysc"
        sb_owner_group = "YP"

        ya_make_abs_paths_glob = [
            "yp/client/**",
            "yp/server/**",
            "yp/yp_proto/**",
            "yt/yt/orm/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class ReleaseViewer(configs.ReferenceCIConfig.ReleaseViewer):
        kpi_alert = 14
        kpi_alert_skip_weekends = True

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            deploy_infos = [
                ri.NannyDeployInfo(
                    [
                        ri.DeployService(name)
                        for name in (
                            "myt_yp_yp_heavy_schedulers",
                            "iva_yp_yp_heavy_schedulers",
                            "man_yp_yp_heavy_schedulers",
                            "vla_yp_yp_heavy_schedulers",
                            "sas_yp_yp_heavy_schedulers",
                        )
                    ],
                    stage=rm_const.ReleaseStatus.stable
                ),
                ri.NannyDeployInfo(
                    ri.DeployService("man_yp_pre_yp_heavy_schedulers"),
                    stage=rm_const.ReleaseStatus.prestable
                ),
                ri.NannyDeployInfo(
                    ri.DeployService("sas_yp_test_yp_heavy_schedulers"),
                    stage=rm_const.ReleaseStatus.testing
                ),
            ]
            return [
                ri.ReleasableItem(
                    name="yp_heavy_scheduler_binary",
                    data=ri.SandboxResourceData("YP_HEAVY_SCHEDULER_BINARY"),
                    build_data=ri.BuildData(
                        target="yp/server/heavy_scheduler/bin/ypserver-heavy-scheduler",
                    ),
                    deploy_infos=deploy_infos,
                ),
                ri.ReleasableItem(
                    name="yp_ortools_solver_binary",
                    data=ri.SandboxResourceData("YP_ORTOOLS_SOLVER_BINARY"),
                    build_data=ri.BuildData(
                        target="yp/server/ortools_solver/ortools-solver",
                    ),
                    deploy_infos=deploy_infos,
                ),
            ]

        allow_old_releases = True
        release_followers_permanent = [
            "bidzilya",
            "se4min",
            "s-berdnikov",
        ]
        allow_robots_to_release_stable = True

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "yp/releases/heavy-scheduler"
        dirs = [
            "arcadia/yp/client",
            "arcadia/yp/server/heavy_scheduler",
            "arcadia/yp/server/lib",
            "arcadia/yp/server/ortools_solver",
            "arcadia/yp/yp_proto",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "se4min"
            queue = "YPREL"
            dev_queue = "YP"
            summary_template = u"Release YP Heavy Scheduler {}"
            add_commiters_as_followers = False
            deadline = 14
            followers = [
                "bidzilya",
                "se4min",
                "s-berdnikov",
            ]
            important_changes_limit = 1000
            notify_on_component_versions_change_to_feature_tickets = core.NOTIFY_ON_COMPONENT_VERSION_CHANGE_TO_FEATURE_TICKETS

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        start_version = 111  # moved to the CI since 111th branch
        branch_name = "yp/heavy_scheduler"
        tag_name = "yp/heavy_scheduler"
