# -*- coding: utf-8 -*-

from . import _yp_core as core

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.core import releasable_items as ri


class YPIdmRoleProvider(core.YPConfigBase):
    name = "yp_idm_role_provider"

    class JG(core.YPJobGraph):
        yp_test_cubes = [
            core.YPTestCube(
                name="test",
                paths=[
                    "yp/idm_role_provider",
                    "yp/python/yp",
                ],
            ),
        ]

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "yp/idm_role_provider/bin"
        secret = "sec-01fgrcn7q2t99yw91w2jkrpysc"
        sb_owner_group = "YP"

        ya_make_abs_paths_glob = [
            "yp/idm_role_provider/**",
            "yp/python/yp/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yp_idm_role_provider_binary",
                    data=ri.SandboxResourceData("YP_IDM_ROLE_PROVIDER_BINARY"),
                    build_data=ri.BuildData(
                        target="yp/idm_role_provider/bin/yp_idm_role_provider",
                    ),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService(name)
                                for name in (
                                    "iva_yp_idm_role_provider",
                                    "myt_yp_idm_role_provider",
                                    "man_yp_idm_role_provider",
                                    "xdc_yp_idm_role_provider",
                                    "vla_yp_idm_role_provider",
                                    "sas_yp_idm_role_provider",
                                )
                            ],
                            stage=rm_const.ReleaseStatus.stable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("man_pre_yp_idm_role_provider"),
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("sas_test_yp_idm_role_provider"),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                    ],
                ),
            ]

        allow_old_releases = True
        release_followers_permanent = [
            "bidzilya",
            "se4min",
        ]
        allow_robots_to_release_stable = True

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "yp/releases/idm-role-provider"
        dirs = [
            "arcadia/yp/idm_role_provider",
            "arcadia/yp/python/yp",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "se4min"
            queue = "YPREL"
            dev_queue = "YP"
            summary_template = u"Release YP IDM Role Provider {}"
            add_commiters_as_followers = False
            deadline = 14
            followers = [
                "bidzilya",
                "se4min",
            ]
            important_changes_limit = 1000
            notify_on_component_versions_change_to_feature_tickets = core.NOTIFY_ON_COMPONENT_VERSION_CHANGE_TO_FEATURE_TICKETS

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        max_active_branches = 4
        start_version = 11  # Moved to the CI since 11th branch.
        branch_name = "yp/idm-role-provider"
        tag_name = "yp/idm-role-provider"
