# -*- coding: utf-8 -*-

from . import _yp_core as core

from sandbox.projects.release_machine.components import configs
from sandbox.projects.release_machine.core import releasable_items as ri, const as rm_const


class YPMasterConfig(core.YPConfigBase):
    name = "yp_master"

    class JG(core.YPJobGraph):
        yp_test_cubes = [
            core.YPTestCube(
                name="test_yp",
                paths=list(core.YP_TEST_PATHS),
            ),
            core.YPTestCube(
                name="test_yt",
                paths=list(core.YT_TEST_PATHS),
            ),
        ]

        yp_build_cubes = [
            core.YPBuildCube(
                name="yp_admin",
                path="yp/python/bin/yp_admin_make/yp-admin",
                resource_description="YP Admin binary",
                resource_type="YP_ADMIN_BINARY",
            ),
        ]

    class CI(configs.ReferenceCIConfig.CI):
        a_yaml_dir = "yp/server/master/bin"
        secret = "sec-01fgrcn7q2t99yw91w2jkrpysc"
        sb_owner_group = "YP"

        ya_make_abs_paths_glob = [
            "yp/client/**",
            "yp/python/**",
            "yp/server/**",
            "yp/yp_proto/**",
            "yt/yt/orm/**",
        ]

        grant_config_update_permissions_to_release_machine_robot = False

    class Releases(configs.ReferenceCIConfig.Releases):
        @property
        def releasable_items(self):
            return [
                ri.ReleasableItem(
                    name="yp_master_binary",
                    data=ri.SandboxResourceData("YP_MASTER_BINARY"),
                    build_data=ri.BuildData(
                        target="yp/server/master/bin/ypserver-master",
                    ),
                    deploy_infos=[
                        ri.NannyDeployInfo(
                            [
                                ri.DeployService(name)
                                for name in (
                                    "myt_yp_yp_masters",
                                    "iva_yp_yp_masters",
                                    "man_yp_yp_masters",
                                    "multi_xdc_yp_yp_masters",
                                    "sas_yp_yp_masters",
                                    "vla_yp_yp_masters",
                                )
                            ],
                            stage=rm_const.ReleaseStatus.stable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("man_yp_pre_yp_masters"),
                            stage=rm_const.ReleaseStatus.prestable
                        ),
                        ri.NannyDeployInfo(
                            ri.DeployService("sas_yp_test_yp_masters"),
                            stage=rm_const.ReleaseStatus.testing
                        ),
                    ],
                ),
            ]

        allow_old_releases = True
        release_followers_permanent = [
            "bidzilya",
        ]
        allow_robots_to_release_stable = True

    class ChangelogCfg(configs.ReferenceCIConfig.ChangelogCfg):
        wiki_page = "yp/releases/master"
        dirs = [
            "arcadia/yp/client",
            "arcadia/yp/python",
            "arcadia/yp/server",
            "arcadia/yp/yp_proto",
            "arcadia/yt/yt/orm",
        ]

    class Notify(configs.ReferenceCIConfig.Notify):
        class Startrek(configs.ReferenceCIConfig.Notify.Startrek):
            assignee = "bidzilya"
            queue = "YPREL"
            dev_queue = "YP"
            summary_template = u"Release YP Master {}"
            add_commiters_as_followers = False
            deadline = 14
            followers = [
                "bidzilya",
            ]
            important_changes_limit = 1000
            notify_on_component_versions_change_to_feature_tickets = core.NOTIFY_ON_COMPONENT_VERSION_CHANGE_TO_FEATURE_TICKETS

    class SvnCfg(configs.ReferenceCIConfig.SvnCfg):
        max_active_branches = 4
        start_version = 85  # Moved to the CI since 85th branch.
        branch_name = "yp/master"
        tag_name = "yp/master"
